/*  The C equivalent of UDFdataPhi,  It consists of a TCL interface over    */
/*  a straight C subroutine                                                 */
/*                                                                          */
/*  There are 3 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  UDF data key/version combination (kV)                      */
/*     OBJV[2]:  The UDF data structure indicator (N)                       */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TudfAnsi.h"
#include "TutilAnsi.h"

int FillPhi (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   void   *memPtr = NULL; 
   ReaL_8 *dPt;
   ByTe_4 iV[20], Bytes;
   ByTe_4 rV, I;
   int    Len;
   ByTe_1 *N, *kV;
   ByTe_1 VarN[20], Index[50];
   u_ByTe_1 *cP[2];

   int Flg = TCL_LEAVE_ERR_MSG;

   Tcl_Obj *rV1;
  
/* MAKE sure that all the IO parameters are present                         */

   if (objc != 3 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: UDFdataPhi kV N");
     return TCL_ERROR;
   }

/* GET the inputs                                                           */
 
   kV = Tcl_GetStringFromObj (objv[1], &Len);
   N  = Tcl_GetStringFromObj (objv[2], &Len);
   rV1 = Tcl_NewObj();

/*  GET the basic internal variables needed                                 */

   BlockVar (tI, 1, kV, "", cP, (ByTe_1 *)iV, 0, (Tcl_Obj *)NULL);
   BlockVar (tI, 2, kV, "", cP, (ByTe_1 *)iV, 8, (Tcl_Obj *)NULL);
   BlockVar (tI, 3, kV, "", cP, (ByTe_1 *)iV, 12, (Tcl_Obj *)NULL);

/* GET pointers to the header and data records                           */

   BlockVar (tI, 0, kV, "", cP, (ByTe_1 *)NULL, 0, (Tcl_Obj *)NULL);

/* GET the number of samples returned with a sensor (NsmP)               */

   iV[14] = *(u_ByTe_2 *)(cP[0] + 24);

/* COMPUTE the number of array elements being returned                   */

   CGetVar (tI, "ExDa", N, ",FULLSWP", 'L', (ByTe_1 *)&iV[16]);
   iV[15] = ((iV[8] == 2) && (iV[16] == 0)) ? 1 : iV[14] - iV[12];

/* GET the return array memory                                           */

   Bytes = sizeof(ReaL_8) * (2 * iV[15]);
   if ((memPtr = malloc (Bytes)) == NULL) { return TCL_ERROR; }

/* CALL the C routine                                                    */

   rV =  FillPhi_C (tI, kV, N, cP, iV, memPtr);

/* PUT the azimuths back into the TCL azimuth array                      */

   sprintf (VarN, "ExPhi%s", N);
   Tcl_UpVar(tI, "#0", VarN, "pA", 0);

   dPt = (ReaL_8 *)memPtr;

   for (I = 0; I < rV; ++I, ++dPt) {
      sprintf(Index, "%d", I);
      rV1 = Tcl_DuplicateObj(rV1);
      Tcl_SetDoubleObj (rV1, *dPt);
      Tcl_SetVar2Ex(tI, "pA", Index, rV1, Flg);
   }

/* GET rid of the temporary array and return                             */

   free (memPtr);
   return TCL_OK;

}

/* THE C ROUTINE                                                            */


ByTe_4 FillPhi_C (Tcl_Interp *tI, ByTe_1 *kV, ByTe_1 *N, u_ByTe_1 **cP, 
                                  ByTe_4 *iV, void *rD)
{
   register ByTe_4 I, J;

   ReaL_8   AccTm, DegPMs;
   ReaL_8   *rV;
   ReaL_8   aO = 0.0, DegAcc, Ang, bA, cT;

   ByTe_4   sN;
   ByTe_4   Spin, TmZero, bMs, bT;
   ByTe_4   Tm[6];

   u_ByTe_2 *Sc;
   int      Off;

/* GET some of the stored information                                    */

   CGetVar (tI, "ExDa", N, ",SEN", 'L', (ByTe_1 *)&sN);
   CGetVar (tI, "ExDa", N, ",SPIN", 'L', (ByTe_1 *)&Spin);
   CGetVar (tI, "ExDa", N, ",ZERO", 'L', (ByTe_1 *)&TmZero);
   CGetVar (tI, "ExDa", N, ",RBMSEC", 'L', (ByTe_1 *)&bMs);

/* Set pointer to store the start and stop azimuth angles           */

   rV = (ReaL_8 *)rD;

/* RETRIEVE the angle offset should one exist                       */

   if (CGetListVar(tI, "SInfo", kV, ",GN,PHI", sN, -1,  'D', (ByTe_1 *)&aO) < 0)
      aO = 0.0;

   J = iV[15];
   if (Spin == 0 ) {
      DegAcc = 0.0;
      Ang = (aO + TmZero) / 100.0;
      Ang = fmod(Ang, 360.0);
      for (I=0; I<iV[15]; ) {
          rV[I++] = Ang;
          rV[J++] = Ang;
      }
   } else {
      AccTm = iV[2] + iV[3] * 1.0e-6;
      DegPMs = 360.0 / (ReaL_4)Spin;
      DegAcc = AccTm * DegPMs;

      CGetVar (tI, "SInfo", kV, ",PT,TOSCAN", 'L', (ByTe_1 *)&Off);
      Sc = (u_ByTe_2 *)(cP[0] + Off);

      bT = bMs - TmZero;
      switch (iV[9]) {
         case 0:
         case 2:
           bA = aO + bT * DegPMs;
           switch (iV[10]) {
              case 0:
                 cT = iV[12] * AccTm;
                 for (I = 0; I < iV[15]; ) {
                    rV[I++] = bA + cT * DegPMs;
                    cT += AccTm;
                 }
              break;
              case 1:
                 for (I = 0; I < iV[15]; ) {
                    cT = Sc[I] * AccTm;
                    rV[I++] = bA + cT * DegPMs;
                 }
              break;
              case 2:
              case 3:
                 for (I = 0; I < iV[15]; ) {
                    cT = abs(Sc[0] - Sc[I]) * AccTm;
                    rV[I++] = bA + cT * DegPMs;
                 }
              break;
           }
         break;
         case 1:
         case 3:
           for (I = 0; I < iV[15]; ) {
              rV[I++] = aO + bT * DegPMs;
           }
         break;
         default:
           bT = aO - TmZero * DegPMs;
           for (I = 0; I < iV[15]; ) {
              TimeData_C (tI, kV, N, iV, Tm);
              rV[I++] = bT + Tm[2] * DegPMs;
              ++iV[12];
           }
         break;
      }

/* PUT all of the starting azimuths between 0 and 360.0 degrees     */

      for (I = 0; I < iV[15]; ++I) {
         rV[I] = fmod((rV[I] + 360.0), 360.0);
      }

/* IF not done set the ending azimuths                              */

       if ( ((iV[9] == 0) || (iV[9] == 2)) && (iV[10] == 3) ) {
          for (I = 1; I < iV[15]; ) { rV[J++] = rV[I++]; }
          rV[J] = rV[--I] + DegAcc;
       } else {
          for (I = 0; I < iV[15]; ) { rV[J++] = rV[I++] + DegAcc; }
       }
    }

    return (2 * iV[15]);
}
