/*  The C equivalent of UDFMath,  It consists of a TCL interface over       */
/*  a straight C subroutine                                                 */
/*                                                                          */
/*  There are 3 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  UDF data key/version combination (kV)                      */
/*     OBJV[2]:  The UDF data structure indicator (N)                       */
/*     OBJV[3]:  The math buffer array                                      */
/*     OBJV[4]:  The algorithm line (LIST variable)                         */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TudfAnsi.h"
#include "TutilAnsi.h"

int DoMath (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   void *memPtr;

   register ReaL_8 *iP, *hP, *oP, *EnD;
   ByTe_4 sN, cM, nTe, nE, CnT, TotB;
   ByTe_4 uI[7], eC, tO;
   ByTe_4 oB, hB, iB;
   ByTe_4 Bytes, MoDe;
   ByTe_1 VaR[20], IndeX[10];

   int Flg = TCL_LEAVE_ERR_MSG;

   Tcl_Obj *aName, *tOp;

   int    Len;
   u_ByTe_1 *tP;
   ByTe_1 *N, *kV, VarN[50];
  
/* MAKE sure that all the IO parameters are present                         */

   if (objc != 5 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: UDFMath kV N Buf uI");
     return TCL_ERROR;
   }

/* GET the inputs                                                           */
 
   kV = Tcl_GetStringFromObj (objv[1], &Len);
   N  = Tcl_GetStringFromObj (objv[2], &Len);

/* PULL out the values from the algorithm line being processed              */
/*   and feed them into an array                                            */

   BlockVar (tI, 6, "", "", (u_ByTe_1 **)NULL, (ByTe_1 *)uI, 0, objv[4]);
   if ( uI[1] < 0 ) { uI[1] = 0; }

/* GET some needed constants                                                */

   CGetVar (tI, "ExDa", N, ",SEN", 'L', (ByTe_1 *)&sN);
   CGetVar (tI, "ExDa", N, ",NSMP", 'L', (ByTe_1 *)&nE);

/*  GET the pointer to the table values                                    */

   sprintf(VarN, "Tbls%s", kV);
   Tcl_UpVar(tI, "#0", VarN, "TbL", 0);
   aName  = Tcl_NewStringObj ("TbL", -1);
   tOp = Tcl_ObjGetVar2(tI, aName, NULL, Flg);
   tP = Tcl_GetByteArrayFromObj(tOp, &Len);
   Tcl_DecrRefCount(aName);


/* GET the offset into the table array                                      */

   CGetListVar (tI, "SInfo", kV, ",TELEM", uI[0], sN, 'L', (ByTe_1 *)&nTe);
   Len = CGetListVar (tI, "SInfo", kV, ",TCMODE", uI[0], sN, 'n', (ByTe_1 *)&eC);
   if (Len == 0) {
      CGetListVar (tI, "SInfo", kV, ",TOFF", uI[0], sN, 'L', (ByTe_1 *)&tO);
   } else {
      CGetListVar (tI, "SInfo", kV, ",TCMODE", uI[0], sN, 'L', (ByTe_1 *)&cM);
      if (cM < 0) {
         CGetListVar (tI, "SInfo", kV, ",TOFF", uI[0], sN, 'L', (ByTe_1 *)&tO);
      } else {
         CGetListVar (tI, "SInfo", kV, ",TCOFF", uI[0], sN, 'L', (ByTe_1 *)&tO);
         sprintf (VaR, "ExMode%s", N);
         sprintf (IndeX, "%d", cM);
         CGetVar (tI, VaR, IndeX, "", 'L', (ByTe_1 *)&MoDe);
         tO += MoDe;
         CGetListVar (tI, "SInfo", kV, ",TCTOTBL", uI[0], tO, 'L', (ByTe_1 *)&tO);
      }
   }
   
   CGetListVar (tI, "SInfo", kV, ",PT,TOTBL", uI[0], -1, 'L', (ByTe_1 *)&eC);
   tO += eC;

/* GET the offsets into the algorithm buffer                                */

   oB = uI[2] * nE;
   hB = uI[6] * nE;
   iB = uI[1] * nE;

/* GET memeory for these buffers and set their pointers                    */

   TotB = sizeof(ReaL_8) * nE;
   Bytes = 3 * TotB;
   if ((memPtr = malloc (Bytes)) == NULL) { return TCL_ERROR; }

   oP = (ReaL_8 *)memPtr;
   iP = (ReaL_8 *)memPtr + nE;
   hP = (ReaL_8 *)memPtr + 2 * nE;
   EnD = oP + nE;

/* TRANSFER the TCL arrays to the C arrays                                 */

   CnT = TclArrayToC (tI, objv[3], (void *)oP, nE, oB, 'D');
   if ( CnT == 0 ) { memset ((void *)oP, 0, TotB); }
   CnT = TclArrayToC (tI, objv[3], (void *)hP, nE, hB, 'D');
   if ( CnT == 0 ) { memset ((void *)hP, 0, TotB); }
   if (uI[4] != '=') {
      CnT = TclArrayToC (tI, objv[3], (void *)iP, nE, iB, 'D');
      if ( CnT == 0 ) { memset ((void *)iP, 0, TotB); }
   }

   switch (uI[4]) {
      case '=':
        for ( ; oP < EnD; ) { *oP++ = TblApply_C(tP, uI[5], tO, nTe, *hP++); }  
      break;
      case '*':
        for ( ; oP < EnD; ) { 
           *oP++ = *iP++ * TblApply_C(tP, uI[5], tO, nTe, *hP++); 
        }  
      break;
      case '-':
        for ( ; oP < EnD; ) { 
           *oP++ = *iP++ - TblApply_C(tP, uI[5], tO, nTe, *hP++); 
        }  
      break;
      case '+':
        for ( ; oP < EnD; ) { 
           *oP++ = *iP++ + TblApply_C(tP, uI[5], tO, nTe, *hP++); 
        }  
      break;
      case '/':
        for ( ; oP < EnD; ) { 
           *oP++ = *iP++ / TblApply_C(tP, uI[5], tO, nTe, *hP++); 
        }  
      break;
      case 'P':
        for ( ; oP < EnD; ) { 
           *oP++ = pow (*iP++, TblApply_C(tP, uI[5], tO, nTe, *hP++)); 
        }  
      break;
      case '<':
        for ( ; oP < EnD; ) { 
          *oP++ = (ByTe_4)*iP++ << (ByTe_4)TblApply_C(tP, uI[5], tO, nTe, *hP++);
        }  
      break;
      case '>':
        for ( ; oP < EnD; ) { 
          *oP++ = (ByTe_4)*iP++ >> (ByTe_4)TblApply_C(tP, uI[5], tO, nTe, *hP++);
        }  
      break;
      case '%':
        for ( ; oP < EnD; ) { 
          *oP++ = (ByTe_4)*iP++ % (ByTe_4)TblApply_C(tP, uI[5], tO, nTe, *hP++);
        }  
      break;
      case '^':
        for ( ; oP < EnD; ) { 
          *oP++ = (ByTe_4)*iP++ ^ (ByTe_4)TblApply_C(tP, uI[5], tO, nTe, *hP++);
        }  
      break;
      case '&':
        for ( ; oP < EnD; ) { 
          *oP++ = (ByTe_4)*iP++ & (ByTe_4)TblApply_C(tP, uI[5], tO, nTe, *hP++);
        }  
      break;
      case '|':
        for ( ; oP < EnD; ) { 
          *oP++ = (ByTe_4)*iP++ | (ByTe_4)TblApply_C(tP, uI[5], tO, nTe, *hP++);
        }  
      break;
   }

/* TRANSFER the C output buffer array back to the  TCL array               */

   oP = (ReaL_8 *)memPtr;
   CArrayToTcl (tI, objv[3], (void *)oP, nE, oB, 'D');

/* GET rid of the temporary array and return                               */

   free (memPtr);

   return TCL_OK;
}
