/*  The C equivalent of UDFdataFill.  THis is a straight C subroutine       */
/*                                                                          */
/*  There are 7 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  UDF data key/version combination (kV)                      */
/*     OBJV[2]:  The UDF data structure indicator (N)                       */
/*     OBJV[3]:  The source of the UDF data                                 */
/*     OBJV[4]:  Any sub-source of the UDF data                             */
/*     OBJV[5]:  The output array                                           */
/*     OBJV[6]:  The data block in the output array to fill (OPTIONAL)      */  

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TudfAnsi.h"
#include "TutilAnsi.h"

int DataFill (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   ReaL_8 V;
   ByTe_4 End;
   ByTe_4 SrcN;
   ByTe_4 I, J, M, KeeP;
   ByTe_4 sSrc;
   int    N, Len, BeG = 0, nE;
   int    NsmP, SmpID, TmRoW;
   ByTe_4 AseT, AusE;
   ByTe_1 VarN[20], Index[50];

   char *rName, *kV, *Src;
  
   int Flg = TCL_LEAVE_ERR_MSG;

   Tcl_Obj *rVO, *rV1;

/* MAKE sure that all the IO parameters are present                         */

   if (objc < 6 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: UDFdataFill kV N, Src ... ");
     return TCL_ERROR;
   }

/* GET the inputs                                                           */
 
   kV   = Tcl_GetStringFromObj (objv[1], &Len);
   Tcl_GetIntFromObj (tI, objv[2], &N);
   Src  = Tcl_GetStringFromObj (objv[3], &Len);
   Tcl_GetIntFromObj (tI, objv[4], &sSrc);

   if (objc == 7 ) { Tcl_GetIntFromObj (tI, objv[6], &BeG); }

/* CONVERT source name to value and get source array                        */

   if ( (strcmp("SENSOR", Src) == 0) || (strcmp("0", Src) == 0) ) {
     SrcN = 0;
     sprintf (VarN, "ExData%d", N); 
     Tcl_UpVar (tI, "#0", VarN, "SrC", 0);
   } else if ( (strcmp("SCAN", Src) == 0) || (strcmp("2", Src) == 0) ) {
      SrcN = 0;
      sprintf (VarN, "ExScan%d", N); 
      Tcl_UpVar (tI, "#0", VarN, "SrC", 0);
   } else if ( (strcmp("MODE", Src) == 0) || (strcmp("4", Src) == 0) ) {
      SrcN = 1;
      sprintf (VarN, "ExMode%d", N); 
      Tcl_UpVar (tI, "#0", VarN, "SrC", 0);
   } else { 
      SrcN = 2;
      sprintf (VarN, "ExAnc%d", N); 
      Tcl_UpVar (tI, "#0", VarN, "SrC", 0);
   }

/* GET the number of samples                                                */

   Tcl_UpVar (tI, "#0", "ExDa", "UDF", 0);
   sprintf(Index, "%d,NSMP", N);  
   if ( (rVO = Tcl_GetVar2Ex(tI, "UDF", Index, Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &nE);
   }

/* GET the output array name                                                */

   rName = Tcl_GetStringFromObj(objv[5], (int *)0);
   rV1 = Tcl_NewObj();

/* SET pointers to the data                                                */

   M = BeG * nE; 
   KeeP = M;

/* NOW transfer the data                                                   */

   switch (SrcN) {
      case 0: 
         for ( I = 0; I < nE; ++I, ++M) {
            sprintf(Index, "%d", I);  
	    rVO = Tcl_GetVar2Ex(tI, "SrC", Index, Flg);
	    Tcl_GetDoubleFromObj (tI, rVO, &V);
            sprintf(Index, "%d", M);  
	    rV1 = Tcl_DuplicateObj(rV1);
	    Tcl_SetDoubleObj (rV1, V);
	    Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
         }
      break;
      case 1: 
         sprintf(Index, "%d", sSrc);  
	 rVO = Tcl_GetVar2Ex(tI, "SrC", Index, Flg);
	 Tcl_GetDoubleFromObj (tI, rVO, &V);
	 rV1 = Tcl_DuplicateObj(rV1);
	 Tcl_SetDoubleObj (rV1, V);

         End = M + nE;
         for ( I = M; I < End; ++I) {
            sprintf(Index, "%d", I);  
	    Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
         }
      break;
      case 2: 
         if (sSrc < 0) { sSrc = -1 - sSrc; }
         Tcl_UpVar (tI, "#0", "SInfo", "sI", 0);
         sprintf(Index, "%s,NSMP", kV);  

         if ( (rVO = Tcl_GetVar2Ex(tI, "sI", Index, Flg)) != NULL) {
            Tcl_GetIntFromObj (tI, rVO, &NsmP);
         }

         CGetListVar (tI, "SInfo", kV, ",PT,ASET", sSrc, -1, 'L', (ByTe_1 *)&AseT); 
         CGetListVar (tI, "SInfo", kV, ",GN,AUSE", sSrc, -1, 'L', (ByTe_1 *)&AusE); 
   
         End = NsmP + M;
         if (AusE == 0) { AusE = NsmP; }
         for ( I = M; I < End; ++AseT) {
	    sprintf(Index, "%d", AseT);  
	    rVO = Tcl_GetVar2Ex(tI, "SrC", Index, Flg);
	    Tcl_GetDoubleFromObj (tI, rVO, &V);
	    rV1 = Tcl_DuplicateObj(rV1);
	    Tcl_SetDoubleObj (rV1, V);
            J = 0;
            while ( (J < AusE) && (I < End) ) {
                sprintf(Index, "%d", I);  
	        Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
	        ++I;
	        ++J;
            }
         }
   
         sprintf(Index, "%s,GN,SMPID", kV);  
         if ( (rVO = Tcl_GetVar2Ex(tI, "sI", Index, Flg)) != NULL) {
            Tcl_GetIntFromObj (tI, rVO, &SmpID);
         }

         if (SmpID == 2) {
            sprintf(Index, "%s,SS,TMROW", kV);  
            if ( (rVO = Tcl_GetVar2Ex(tI, "sI", Index, Flg)) != NULL) {
               Tcl_GetIntFromObj (tI, rVO, &TmRoW);
            }

	    J = TmRoW + KeeP;
	    End = J + nE;
   
            for ( I = KeeP; J < End; ++I, ++J) {
               sprintf(Index, "%d", J);  
	       rVO = Tcl_GetVar2Ex(tI, rName, Index, Flg);
	       Tcl_GetDoubleFromObj (tI, rVO, &V);
               sprintf(Index, "%d", I);  
	       rV1 = Tcl_DuplicateObj(rV1);
	       Tcl_SetDoubleObj (rV1, V);
	       Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
            }
         }
      break;
   }

   return TCL_OK;
}
