/*  Get a variable from a Tcl UDF list element                             */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TudfAnsi.h"

ByTe_4 CGetListVar (Tcl_Interp *tI, ByTe_1 *Var, ByTe_1 *E1, ByTe_1 *E2, 
                             ByTe_4 PosA, ByTe_4 PosB, ByTe_1 FmT, ByTe_1 *rV)
{
   ReaL_8  dV;
   int     iV;

   int eC, lLen;
   ByTe_1 Index[40];

   int Flg = TCL_LEAVE_ERR_MSG;
   Tcl_Obj *rVO, *rV1, *rV2, *rV3;
                                                                  
/* THIS is variable.  E1 holds the Key,Ver and E2 the element name */

   sprintf (Index, "%s%s", E1, E2);

   Tcl_UpVar(tI, "#0", Var, "vL", 0);

/* IF the variable does not exist then return a length of -1 */

   if ( (rVO = Tcl_GetVar2Ex(tI, "vL", Index, Flg)) == NULL) { return(-1); }

/* VARIABLE exists so get its length */

   eC = Tcl_ListObjLength(tI, rVO, &lLen);

/* IF no format then we just return its length */

   if (FmT == 'N')  { return (ByTe_4)lLen; }

/* IF after an position larger than the list length return -1 */

   if (PosA >= lLen)  { return -1; }

/* GET the pointer to the list element and return -1 if no pointer */

   eC = Tcl_ListObjIndex(tI, rVO, (int)PosA, &rV1);
   if ( rV1 == 0 ) { return -1; }

/* IF PosB is >= zero then what we just got is also a list and we are  */
/*   after an element in that list at PosB.  So rerun the above checks */

   if ( PosB >= 0 ) {
      eC = Tcl_ListObjLength(tI, rV1, &lLen);
      if (FmT == 'n')  { return (ByTe_4)lLen; }

      if (PosB >= lLen)  { return -1; }
      eC = Tcl_ListObjIndex(tI, rV1, PosB, &rV2);
      if ( rV2 == 0) { return -1; }

      rV3 = rV2;
   } else { rV3 = rV1; }

   switch (FmT) {
      case 'D':
        Tcl_GetDoubleFromObj(tI, rV3, (ReaL_8 *)rV);
      break;
      case 'F':
        Tcl_GetDoubleFromObj(tI, rV3, &dV);
        *(ReaL_4 *)rV = dV;
      break;
      case 'L':
        Tcl_GetIntFromObj(tI, rV3, (ByTe_4 *)rV);
      break;
      case 'S':
        Tcl_GetIntFromObj(tI, rV3, &iV);
        *(ByTe_2 *)rV = iV;
      break;
      case 'C':
        Tcl_GetIntFromObj(tI, rV3, &iV);
        *(ByTe_1 *)rV = iV;
      break;
   }

   return (ByTe_4)lLen;
}
