package provide ShockNormal 1.0

# Puts up scatter plots of the shock velocity


proc SNsvelPlot { Xv Yv nP iD} {
   global SNcommon guiAns GphInfo

   upvar $Xv X
   upvar $Yv Y

   set cV [list Blue Green Yellow Red ]

   set W .vWin
   if ![winfo exists $W] {
      toplevel $W
      GUIFrame $W.sp 0 pack|top||both
      set tS 10
      set xC 500 ; set yC 500 ; set tS 12

      GUICanvas $W.sp $xC $yC $xC $yC
      SetScreen 2 $W.sp
      GenWindow sW0 0. 0. 0. 1. 1. 0. 0. 0. 0. 1. 1. 0.

      TextProp $tS
      set cS [GPHtextLen M XY]
      set cX [lindex $cS 0]
      set cY [lindex $cS 0]

      set xB [expr 8.0 * $cX] ; set xT [expr 1. - 2.0 * $cX]
      set yB [expr 4.0 * $cY] ; set yT [expr 1. - 4.0 * $cY]
      set xLb  [expr ($xB + $xT)/2.0]

      RelWindow 33 sW0 $xB $yB 0. $xT $yT 0. 0. -500. 0. 4. 200. 0.
      DefinePlot 33 33

#     AutoScale 33 Xb X $nP 
#     AutoScale 33 Yb Y $nP 

      set LaB [list V 1.0 NV 1.0]
      set NuM [list BOT BOT BOTH BOTH]
      PlotOutlines 33 $LaB $NuM
   } else { SetScreen 2 $W.sp }

   set opX [list <= 0.0]
   set opY [list $GphInfo([lindex $cV $iD]) <= -1.0e20 HOLD 8 +]

    set EnD [expr $nP - 1]
    Plot2D 33 Xb Yb X Y 0 $EnD SCATTER $opY $opX
    update
    SetScreen 0 NONE
}
