# This procedure saves the menu entries

package provide ShockNormal 1.0

proc SNsaveMenu { } {
   global env guiAns 

   if [catch {open $guiAns(SaveName) w} fd] {
      puts stderr "UNABLE TO OPEN SAVEFILE: $guiAns(SaveName)"
      return
   }

# From the INFO menu

   puts $fd "duse|$guiAns(duse)|.giINFO.data.duse|PRI|T"
   puts $fd "dSmooth|$guiAns(dSmooth)|.giINFO.data.dsmo|PRI|O"
   puts $fd "dFlen|$guiAns(dFlen)"
   puts $fd "dSGorder|$guiAns(dSGorder)"
   puts $fd "gamma|$guiAns(gamma)"

# From the DATA DEFINITION menu

   set fId [list A B C D E]
   for { set I 0 } { $I < 5 } { incr I } {
      set iD [lindex $fId $I]
      set W .giDATA.var$I
      puts $fd "fN$iD|$guiAns(fN$iD)"
      puts $fd "tM$iD|$guiAns(tM$iD)|$W.tM$iD|ALT|O"
      puts $fd "tMf$iD|$guiAns(tMf$iD)"
      for { set J 1 } { $J <= 5 } { incr J } {
         set vaR v${J}$iD
         set unit u${J}$iD
         puts $fd "$vaR|$guiAns($vaR)|$W.$vaR|PRI|O"
         puts $fd "$unit|$guiAns($unit)|$W.$unit|PRI|O"
      }
   }

   close $fd
}
