package provide ShockNormal 1.0

#
#  Computes the average and varience of the input data to the Rankine-Hugoniot 
#  equations
#
#  INPUTS:   None
#
#  OUTPUTS:  None

proc SNrhStat { n1 t1 v1 b1 n2 t2 v2 b2 aVg vAr}  {
   global guiAns SNcommon

   upvar $n1  N1
   upvar $t1  T1
   upvar $v1  V1
   upvar $b1  B1
   upvar $n2  N2
   upvar $t2  T2
   upvar $v2  V2
   upvar $b2  B2
   upvar $aVg AvG
   upvar $vAr VaR

# Set the number of data points to include on each side depending on if
#    the data is being PERMUTATED or MIRRORED

   set J 0
   set Stat [ TUdataStat N1 $SNcommon(Pt1) ]
   set AvG($J)  [lindex $Stat 0]
   set VaR($J) [expr sqrt([lindex $Stat 1])]
   incr J

   set Stat [ TUdataStat T1 $SNcommon(Pt1) ]
   set AvG($J)  [lindex $Stat 0]
   set VaR($J) [expr sqrt([lindex $Stat 1])]
   incr J

   for { set I 0 } { $I < 3 } { incr I ; incr J } {
      set Stat [ TUdataStat V1 $SNcommon(Pt1) 3 $I ]
      set AvG($J) [lindex $Stat 0]
      set VaR($J) [expr sqrt([lindex $Stat 1])]
   }

   for { set I 0 } { $I < 3 } { incr I ; incr J } {
      set Stat [ TUdataStat B1 $SNcommon(Pt1) 3 $I ]
      set AvG($J) [lindex $Stat 0]
      set VaR($J) [expr sqrt([lindex $Stat 1])]
   }

   set Stat [ TUdataStat N2 $SNcommon(Pt2) ]
   set AvG($J) [lindex $Stat 0]
   set VaR($J) [expr sqrt([lindex $Stat 1])]
   incr J

   set Stat [ TUdataStat T2 $SNcommon(Pt2) ]
   set AvG($J)  [lindex $Stat 0]
   set VaR($J) [expr sqrt([lindex $Stat 1])]
   incr J

   for { set I 0 } { $I < 3 } { incr I ; incr J } {
      set Stat [ TUdataStat V2 $SNcommon(Pt2) 3 $I ]
      set AvG($J) [lindex $Stat 0]
      set VaR($J) [expr sqrt([lindex $Stat 1])]
   }

   for { set I 0 } { $I < 3 } { incr I ; incr J } {
      set Stat [ TUdataStat B2 $SNcommon(Pt2) 3 $I ]
      set AvG($J) [lindex $Stat 0]
      set VaR($J) [expr sqrt([lindex $Stat 1])]
   }

   set C0 [expr $SNcommon(Pt1) * ($SNcommon(Pt2) - 1 ) ]
   set C1 [expr sqrt($C0 / ($SNcommon(Pt1) * ($SNcommon(Pt2) - 1 ))) ]
   set C2 [expr sqrt($C0 / ($SNcommon(Pt1) * ($SNcommon(Pt2) - 1 ))) ]
   set J 8
   for { set I 0 } { $I < 8 } { incr I; incr J } {
      set VaR($I) [expr $C1 * $VaR($I)]
      set VaR($J) [expr $C2 * $VaR($J)]
   }
}
