package provide ShockNormal 1.0

proc SNrhSolve { } {
   global RtoD SNcommon guiAns sP N1 N2 V1 V2 B1 B2

   if {$SNcommon(Phi) < 0.0 } { 
       GUImsgPopUp .ewin 30 5 "ERROR: No initial guess"
       return 
   }

   SNclearInfo PRES

   for { set I 0 } { $I < $SNcommon(Pt) } { incr I } { 
      set yV($I) 0.0 
      set WgT($I) 1.0 
   }
   set Hold(0) 1
   set Hold(1) 1

   set CoeF(0) [expr $SNcommon(Phi) / $RtoD ]
   set CoeF(1) [expr $SNcommon(Theta) / $RtoD ]

   SNrhFit yV WgT CoeF Hold
 
   SNshockVel 3 
   if { $SNcommon(Side) == 0 } {
      SNdataAnc 3 $SNcommon(Pt1) N1 V1 B1
   } else { SNdataAnc 3 $SNcommon(Pt2) N2 V2 B2 }

   GUIstateSet .gmMIDDLE.topA.solve PBUTTON disabled
   GUIstateSet .gmMIDDLE.topA.asym  PBUTTON normal
}
