package provide ShockNormal 1.0

# THIS program derives a shock normal by minimizing the Rankine-Hugonoit 
# equations across the shock.
#
# AUTHOR- A. FIGUEROA-VINAS 8/17/83.
# TO Tcl  C. Gurgiolo  2002

proc SNrhSetUp { } {
   global PI RtoD N1 T1 V1 B1 N2 T2 V2 B2 Np sP \
                  nN1 nP1 nV1 nB1 nN2 nP2 nV2 nB2  \
                  AvG SNcommon XTm DeN MagF VeL TemP guiAns

# Set the number of data points to include on each side depending on if
#    the data is being PERMUTATED or MIRRORED
 
   set fPI [expr 4.0 * $PI]
   set N $SNcommon(nP)
   set SNcommon(Mass) [expr 1.6726E-24 * $guiAns(mass)]
   set SNcommon(dA) .0001
   set SNcommon(Boltz) 1.3807E-16

# GET the surface plot information

   SNgetPTinfo 

# IF the user has changed times then get the data

   if { $SNcommon(ChgTm) == 1 } {
      if { [SNdataStore XTm DeN MagF VeL TemP $N] < 0 } { return }
   }
  
# IF the user has changed how the data is to be processed (MIRROR or
#    PERMUTATION) then we need to recompute the statistics and the
#    renormalize the data.

   if { ($SNcommon(ChgdP) == 1) || ($SNcommon(ChgTm) == 1) } {

# Set the number of data points to include on each side depending on if
#    the data is being PERMUTATED or MIRRORED
 
      set SNcommon(Pt1) $SNcommon(nP1)
      set SNcommon(Pt2) $SNcommon(nP2)
      if [string match MIRRORED $guiAns(duse)] {
         if { $SNcommon(Pt1) < $SNcommon(Pt2) } { 
            set SNcommon(Pt2) $SNcommon(Pt1) 
         } else { set SNcommon(Pt1) $SNcommon(Pt2) }
         set SNcommon(Pt) $SNcommon(Pt1)
      } else { set SNcommon(Pt) [expr $SNcommon(Pt1) * $SNcommon(Pt2)] }
 
# COMPUTE some statistics associated with the input data sets


      SNrhStat N1 T1 V1 B1 N2 T2 V2 B2 AvG VaR

# DETERMINE the UPSTREAM side of the data

      set Vmag1 [TUvecMath AvG MAG AvG AvG 2]
      set Bmag1 [TUvecMath AvG MAG AvG AvG 5]
      set Vmag2 [TUvecMath AvG MAG AvG AvG 10]
      set Bmag2 [TUvecMath AvG MAG AvG AvG 13]
      set dN  [expr $AvG(8) - $AvG(0) ]
      set dV  [expr $Vmag2 - $Vmag1]
      set dB  [expr $Bmag2 - $Bmag1]
      set dBdN [expr $dB * $dN]
      set dVdN [expr $dV * $dN]

# sTYPE(0) - FORWARD (1) or REVERSE (0) shock
# sTYPE(1) - FAST (1) or SLOW (0) shock

      if { $dBdN > 0.0 } { 
         set sType(1) 1 
         set guiAns(shki) FAST
      } else { 
         set sType(1) 0 
         set guiAns(shki) SLOW
      }
      if { $dVdN > 0.0 } { 
          set sType(0) 1 
          append guiAns(shki) " FORWARD"
      } else { 
          set sType(0) 0 
          append guiAns(shki) " REVERSE"
      }

# GET the scaling parameters.  These are generated from the upstream side
#   of the data

      if { $sType(0) == 1 } {
         set sP(0) $AvG(0)
         set sP(1) $Vmag1
         set SNcommon(Side) 0
         append guiAns(shki) " (Low Entropy Side is 1)"
      } else {
         set sP(0) $AvG(8)
         set sP(1) $Vmag2
         set SNcommon(Side) 1
         append guiAns(shki) " (Low Entropy Side is 2)"
      }

      set sP(2) [expr 1.0e10 * $sP(1) * sqrt($fPI * $SNcommon(Mass) * $sP(0))]
      set sP(3) [expr 1.0e10 * $sP(1) * $sP(1) *$SNcommon(Mass) * $sP(0)]

      update

      if [string match MIRRORED $guiAns(duse)] {
         for { set I 0 } { $I < $SNcommon(Pt1) } { incr I } {
            set dTaP($I) [expr $N2($I) * $T2($I) - $N1($I) * $T1($I)]
         }
      } else {
         set K 0
         for { set I 0 } { $I < $SNcommon(Pt2) } { incr I } {
            set TmP [expr $N2($I) * $T2($I)]
            for { set J 0 } { $J < $SNcommon(Pt1) } { incr J ; incr K } {
               set dTaP($K) [expr $TmP - $N1($J) * $T1($J)]
            }
         }
      }

      set ReT [TUdataStat dTaP $SNcommon(Pt) ]
      set dPAvG [lindex $ReT 0 ]
      set dPVaR [lindex $ReT 1 ]

# DO alternate shock normal solutions.  These are:
#
#   0: MAGNETIC COPLANARITY
#   1: ABRAHAM-SHRAUNER
#   2: VELOCITY COPLANARITY

      for { set I 0 } { $I < 3 } { incr I } { SNshockSol $I }

      SNdataMerge
      SNrhPreFunc

      set SNcommon(ChgdP) 0
   }

   SNdifSurface
   GUIstateSet .gmMIDDLE.topA.setup PBUTTON disabled
}
