package provide ShockNormal 1.0

#  This procedure computes vectors and tensors used in the calculation of 
#  the Rankine-Hugoniot equations and their derivitives that are based soley 
#  on the input data.  As such they only need to be computed once and not 
#  at each iteration in the search for the optimum shock normal.
#
#  There is one computed tensor or vector for each set of data points.
#  These values are stacked in their respective arrays.
#
#  Computed are:
#    aV:  N2V2 - N1V1
#    bV:  bV/(N2 - N1) 
#    cV:  (V2 x B2) - (V1 x B1)
#    dB:  B2 - B1

proc SNrhPreFunc { } {
   global  nN1 nP1 nV1 nB1 nN2 nP2 nV2 nB2 dN aV bV dB dP cV aT cT dT \
             guiAns SNcommon 

   set X    0
   set vInc 0
   set tInc 0

   for  { set I 0 } { $I < $SNcommon(Pt) } { incr I ; incr X 3 } {
      set dN($I) [expr $nN2($I) - $nN1($I)]
      set dP($I) [expr $nP2($I) - $nP1($I)]
      TUvecMath nB2 - nB1 dB $X $X $vInc

      TUvecMath nV1 * nN1 tV1a $X $I 0 3 1
      TUvecMath nV1 TENSOR tV1a tV1b $X 
      TUvecMath nV2 * nN2 tV2a $X $I 0 3 1
      TUvecMath nV2 TENSOR tV2a tV2b $X 
      TUvecMath tV2a - tV1a aV 0 0 $vInc
      TUvecMath aV / dN bV $vInc $I $vInc 3 1

      TUvecMath nB1 TENSOR nB1 tV1a $X $X
      TUvecMath tV1b - tV1a tP1 0 0 0 9 9
      TUvecMath nB2 TENSOR nB2 tV2a $X $X
      TUvecMath tV2b - tV2a tP2 0 0 0 9 9
      TUvecMath tP2 - tP1 aT 0 0 $tInc 9 9

      TUvecMath nV1 CROSS nB1 tV1a $X $X
      TUvecMath nV2 CROSS nB2 tV2a $X $X
      TUvecMath tV2a - tV1a cV 0 0 $vInc


      incr vInc 3
      incr tInc 9
   }
}
