# This procedure reads the menu entries

package provide ShockNormal 1.0

proc SNreadMenu { } {
   global env guiAns GUIoptPri GUIoptAlts

   if [catch {open $guiAns(ReadName) r} fd] {
      puts stderr "UNABLE TO OPEN MENUFILE: $guiAns(ReadName)"
      return
   }

#  READ in the saved values 

   while { [gets $fd line] > 0 } {
      set Ops [split $line '|']
      set entry [lindex $Ops 0]
      set guiAns($entry) [lindex $Ops 1]
      if { [llength $Ops] > 2 } {
         set W    [lindex $Ops 2]
         set Pos  [lindex $Ops 3]
         set Type [lindex $Ops 4]
         switch -exact -- $Type {
            O { set Item [GUIoptsInfo $W OPTV $guiAns($entry) $Pos PRI] }
            T {  
               if [string match ALT $Pos] { 
                  set Pos [lsearch $GUIoptAlts($W) $guiAns($entry)] 
                  set Item [lindex $GUIoptPri($W) $Pos] 
               } else { set Item $guiAns($entry) }
            } 
         }
         $W configure -fg #000000
         GUIchgConf $W $Item
      }
   }

   close $fd
}
