package provide ShockNormal 1.0

proc SNprintRes { } {
   global Prefs SNcommon guiDefaults guiAns

   set Fmt1  "%12.5e"
   set Fmt3  "%12.5e %13.5e %13.5e"
   set FmtTm "%d %d %02d:%02d:%02d.%03d"

   if [catch {open $guiAns(PrintName) w} fd] {
      set Msg "ERROR: Can't open $guiAns(PrintName) for output"
      GUImsgPopUp .ewin 30 5 $Msg
      return -1
   }

   puts $fd "INPUT DATA FILE      :  $SNcommon(dFile)"
   puts $fd "DATA PAIRING         :  $guiAns(duse)"
   puts $fd "GAMMA                :  [format $Fmt1 $guiAns(gamma)]"

   set Tm [format $FmtTm $guiAns(skTmYr) $guiAns(skTmDy) $guiAns(skTmHr) \
                         $guiAns(skTmMn) $guiAns(skTmSc) $guiAns(skTmMs)]
   puts $fd "SHOCK TIME           :  $Tm"
   set Tm [format $FmtTm $guiAns(s1TaYr) $guiAns(s1TaDy) $guiAns(s1TaHr) \
                          $guiAns(s1TaMn) $guiAns(s1TaSc) $guiAns(s1TaMs)]
   puts $fd "BEG TIME Side 1      :  $Tm"
   set Tm [format $FmtTm $guiAns(s1TbYr) $guiAns(s1TbDy) $guiAns(s1TbHr) \
                         $guiAns(s1TbMn) $guiAns(s1TbSc) $guiAns(s1TbMs)]
  puts $fd "END TIME Side 1      :  $Tm"
   set Tm [format $FmtTm $guiAns(s2TaYr) $guiAns(s2TaDy) $guiAns(s2TaHr) \
                         $guiAns(s2TaMn) $guiAns(s2TaSc) $guiAns(s2TaMs)]
   puts $fd "BEG TIME Side 2      :  $Tm"
   set Tm [format $FmtTm $guiAns(s2TbYr) $guiAns(s2TbDy) $guiAns(s2TbHr) \
                         $guiAns(s2TbMn) $guiAns(s2TbSc) $guiAns(s2TbMs)]
   puts $fd "END TIME Side 2      :  $Tm"

   puts $fd ""
   puts $fd "SHOCK                :  $guiAns(shki)"
 
   set ResList [list X Y Z PH TH SV TBN MA NA VXA VYA VZA BXA BYA BZA \
                                              NB VXB VYB VZB BXB BYB BZB DP ]
   set LabList  [list "Nx                    " \
                      "Ny                    " \
                      "Nz                    " \
                      "Phi (degrees)         " \
                      "Theta (degrees)       " \
                      "Vs (km/sec)           " \
                      "ThetaBN (degrees)     " \
                      "Ma                    " \
                      "Density Side-1 (/cc)  " \
                      "Vx Side 1 (km/sec)    " \
                      "Vy Side-1 (km/sec)    " \
                      "Vz Side-1 (km/sec)    " \
                      "Bx Side 1 (nT)        " \
                      "By Side-1 (nT)        " \
                      "Bz Side-1 (nT)        " \
                      "Density Side-2 (/cc  )" \
                      "Vx Side 2 (km/sec)    " \
                      "Vy Side-2 (km/sec)    " \
                      "Vz Side-2 (km/sec)    " \
                      "Bx Side 2 (nT)        " \
                      "By Side-2 (nT)        " \
                      "Bz Side-2 (nT)        " \
                      "Delta Pressure (eV/cc)" ]

   set SolList [ list "MAGNETIC COPLANARITY" "ABRAHAM-SHRAUNER" \
                 "VELOCITY COPLANARITY" "VINAS-SCUDDER" ]
   puts $fd ""
   puts $fd "SOLUTION INFORMATION"

   set Len  [ llength $ResList ]
   set sLen [ llength $SolList ]
   for { set J 0 } { $J < $sLen } { incr J } {
      puts $fd ""
      puts $fd ""
      puts $fd "[lindex $SolList $J] (Value : 1 Sigma)"
      puts $fd ""
      for { set I 0 } { $I < $Len } { incr I } {
          set Lb [lindex $LabList $I]
          set Nm [lindex $ResList $I]
          if { [string length $guiAns(${Nm}$J)] == 9 } {
             set Val " $guiAns(${Nm}$J)"
          } else { set Val $guiAns(${Nm}$J) }
          set Line [format "%s   %s : %s" $Lb $Val $guiAns(${Nm}s$J)]
          puts $fd $Line
      }
   }

   close $fd
}
