package provide ShockNormal 1.0

proc SNplotData { W } {
   global SNcommon GphInfo WinInfo PltInfo TimE MagF VeL TemP \
          XTm DeN guiAns pMF pVE pTM pDN DevInfo
   
   if $SNcommon(getData) {
       SNreadData
       set SNcommon(getData) 0
       if { $SNcommon(dEnd) < 0 } {
          set SNcommon(dBeg) 0
          set SNcommon(dEnd) [expr $SNcommon(nP) - 1]
       }
   } elseif { $SNcommon(nLines) == 2 } {
      SNdataReMap XTm $SNcommon(nP)
   } elseif { $SNcommon(nLines) == 0 } {
      set SNcommon(dBeg) 0
      set SNcommon(dEnd) [expr $SNcommon(nP) - 1]
   } else { return }

#  TURN on the graphics and establish the plot windows.  Only need to do
#     this if its never been done.

   if !$SNcommon(PlotUp) {
      GraphicsOn TK $guiAns(ctbl) 0 $W
      GenWindow 0 0.15 0.12 0.0 0.95 0.32 0.0  0. 0. 0. 360. 4. 0. X
      GenWindow 1 0.15 0.32 0.0 0.95 0.52 0.0  0. 0. 0. 360. 4. 0. X
      GenWindow 2 0.15 0.52 0.0 0.95 0.72 0.0  0. 0. 0. 360. 4. 0. X
      GenWindow 3 0.15 0.72 0.0 0.95 0.92 0.0  0. 0. 0. 360. 4. 0. X
      PlotColor HOLD $GphInfo(White) -1

#  NEED to determine a reasonable font size since the user may have
#    changed the overall canvas size.

      set GphInfo(curWin) 3
      set TotX [expr 0.15 * ($WinInfo(3,pp3) - $WinInfo(3,pp0))]
      set TotY [expr $WinInfo(3,pp4) - $WinInfo(3,pp1)]
      set cSize 15
      TextProp $cSize
      set cL [GPHtextLen "5" XY ]
      set Xc [expr 8.0 * [lindex $cL 0]]
      set Yc [expr 8.0 * [lindex $cL 1]]
      while { (($Yc > $TotY) || ($Xc > $TotX)) && ($cSize > 5) } {
         incr cSize -1
         TextProp $cSize
         set cL [GPHtextLen "5" XY ]
         set Xc [expr 8.0 * [lindex $cL 0]]
         set Yc [expr 8.0 * [lindex $cL 1]]
      }

      set SNcommon(cSize) $cSize
   } else { SetScreen 0 .gmMiddle.data }
   ClearWindow bW0 $GphInfo(Black)
   update

#  DEFINE the plots

   for { set I 0 } { $I < 4 } { incr I } {
      DefinePlot $I $I X $TimE($SNcommon(dBeg)) $TimE($SNcommon(dEnd))
      PLTinfoChg $I ALL NUMBERS NSIZE $SNcommon(cSize)
      PLTinfoChg $I ALL NUMBERS TSIZE $SNcommon(cSize)
      if { $I != 3 } { PLTinfoChg $I ALL NUMBERS NENDS MAX } 
      PLTinfoChg $I ALL TICKS MJNUMBER 5
      PLTinfoChg $I ALL TICKS MNNUMBER 1
   }

   set Base [lindex $PltInfo(0,TmI) 1]
   set SNcommon(Base) $Base
   set SNcommon(TBase) $TimE(0)

   set BTm $TimE($SNcommon(dBeg)) 
   set Yr [lindex $BTm 0] 
   set Dy [lindex $BTm 1]
   set Hr [lindex $BTm 2]
   set Mn [lindex $BTm 3]
   set Sc [lindex $BTm 5]
   set TopLab [format "%d %03d %02d:%02d:%02d" $Yr $Dy $Hr $Mn $Sc]

# SET up the X array

   for { set I 0 } {$I < $SNcommon(nP)} {incr I } {
      set XTm($I) [TUtimeConv $SNcommon(TBase) $TimE($I) 0 SNcommon(Base)]
   }

# ESTABLISH the plot grid parameters

   set YY(0) 0.0

   set gInfo(0) $XTm($SNcommon(dBeg))
   set gInfo(1) $XTm($SNcommon(dEnd))
   set gInfo(2) -1.0
   set gInfo(3) 1.0
   set gInfo(4) [expr int([lindex $PltInfo(0,Pix) 0])]
   set gInfo(5) 1
   set gInfo(6) POINT
   set gInfo(7) POINT
   set gInfo(8) COLUMN
   set gInfo(9) KEEP
   set gInfo(10) NEW:ADD:END
   set gInfo(11) 10000.0
   set gInfo(12) -1.0
   set gInfo(13) 0.0
   set gInfo(14) 1.0e30
   set gInfo(15) YES
   set gInfo(16) NO

   set Op(0) $guiAns(dFlen)
   set Op(1) $guiAns(dFlen)
   set Op(2) $guiAns(dSGorder)

# SET Savitzky-Golay Filter AutoScale parameters

   if [string match SAVITZKYGOLAY $guiAns(dSmooth)] {
      if { $SNcommon(dBeg) > $Op(0) } { 
          set Beg $SNcommon(dBeg)
          set End $SNcommon(dEnd)
      } else { set Beg $Op(0) ; set End [expr $SNcommon(nP) - $Op(0)] } 
      set ASoP [list -1.0e33 1.0e33 OFF OFF OFF OFF -1.0 OFF $Beg]
   } else { 
      set Beg $SNcommon(dBeg)
      set End $SNcommon(dEnd)
      set ASoP [list -1.0e33 1.0e33 OFF OFF OFF OFF -1.0 OFF $Beg]
   }

   set aSEnd [expr $End - $Beg]

   TUdataGrid $SNcommon(nP) 1 XTm XTm $SNcommon(nP) YY YY pMF dGrid Norm gInfo
   TUgridFill1D dGrid gInfo X HF -1 1

   AutoScale 0 Yb pMF $aSEnd $ASoP
   PlotOutlines 0 [list X 2.5 "" 6.75 "" 1.0 "MF" 1.0] 
   Plot2D 0 Xb Yb AB dGrid -1 0 LINE [list 150 < -1.0e30]

   TUdataGrid $SNcommon(nP) 1 XTm XTm $SNcommon(nP) YY YY pVE dGrid Norm gInfo
   TUgridFill1D dGrid gInfo X HF -1 1
   AutoScale 1 Yb pVE $aSEnd $ASoP
   PlotOutlines 1 [list "" 2.5 "" 6.75 "" 1.0 "VEL" 1.0 ]  [list NONE BOT]
   Plot2D 1 Xb Yb AB dGrid -1 0 LINE [list 150 < -1.0e30]

   TUdataGrid $SNcommon(nP) 1 XTm XTm $SNcommon(nP) YY YY pDN dGrid Norm gInfo
   TUgridFill1D dGrid gInfo X HF -1 1
   AutoScale 2 Yb pDN $aSEnd $ASoP
   PlotOutlines 2 [list "" 2.5 "" 6.75 "" 1.0 "DEN" 1.0]  [list NONE BOT]
   Plot2D 2 Xb Yb AB dGrid -1 0 LINE [list 150 < -1.0e30]

   TUdataGrid $SNcommon(nP) 1 XTm XTm $SNcommon(nP) YY YY pTM dGrid Norm gInfo
   TUgridFill1D dGrid gInfo X HF -1 1
   AutoScale 3 Yb pTM $aSEnd $ASoP 
   PlotOutlines 3 [list "" 2.5 "" 6.75 "" 1.0 "TEMP" 1.0]  [list NONE BOT]
   Plot2D 3 Xb Yb AB dGrid -1 0 LINE [list 150 < -1.0e30]

   TextProp $SNcommon(cSize)
   set GphInfo(curWin) 3
   set Yt [expr $WinInfo(3,p4) + [GPHtextLen "A" Y ] ]
   TexT 3 0.0 $Yt 0.0 right $TopLab $GphInfo(White) 

#  DISPLAY time selections if they exist.

   if { $SNcommon(PixS) >= 0 } {
      PlotColor HOLD $GphInfo(Red) HOLD
      set dX $SNcommon(PixS)
      Line 0 $dX $WinInfo(0,p1) 0 $dX $WinInfo(0,p4) 0 LineS
      Line 1 $dX $WinInfo(1,p1) 0 $dX $WinInfo(1,p4) 0 LineS
      Line 2 $dX $WinInfo(2,p1) 0 $dX $WinInfo(2,p4) 0 LineS
      Line 3 $dX $WinInfo(3,p1) 0 $dX $WinInfo(3,p4) 0 LineS
   }
   if { $SNcommon(PixS1a) >= 0 } {
      PlotColor HOLD $GphInfo(Cyan) HOLD
      set dX $SNcommon(PixS1a)
      Line 0 $dX $WinInfo(0,p1) 0 $dX $WinInfo(0,p4) 0 LineS1a
      Line 1 $dX $WinInfo(1,p1) 0 $dX $WinInfo(1,p4) 0 LineS1a
      Line 2 $dX $WinInfo(2,p1) 0 $dX $WinInfo(2,p4) 0 LineS1a
      Line 3 $dX $WinInfo(3,p1) 0 $dX $WinInfo(3,p4) 0 LineS1a
   }
   if { $SNcommon(PixS1b) >= 0 } {
      PlotColor HOLD $GphInfo(Cyan) HOLD
      set dX $SNcommon(PixS1b)
      Line 0 $dX $WinInfo(0,p1) 0 $dX $WinInfo(0,p4) 0 LineS1b
      Line 1 $dX $WinInfo(1,p1) 0 $dX $WinInfo(1,p4) 0 LineS1b
      Line 2 $dX $WinInfo(2,p1) 0 $dX $WinInfo(2,p4) 0 LineS1b
      Line 3 $dX $WinInfo(3,p1) 0 $dX $WinInfo(3,p4) 0 LineS1b
   }
   if { $SNcommon(PixS2a) >= 0 } {
      PlotColor HOLD $GphInfo(Yellow) HOLD
      set dX $SNcommon(PixS2a)
      Line 0 $dX $WinInfo(0,p1) 0 $dX $WinInfo(0,p4) 0 LineS2a
      Line 1 $dX $WinInfo(1,p1) 0 $dX $WinInfo(1,p4) 0 LineS2a
      Line 2 $dX $WinInfo(2,p1) 0 $dX $WinInfo(2,p4) 0 LineS2a
      Line 3 $dX $WinInfo(3,p1) 0 $dX $WinInfo(3,p4) 0 LineS2a
   }
   if { $SNcommon(PixS2b) >= 0 } {
      PlotColor HOLD $GphInfo(Yellow) HOLD
      set dX $SNcommon(PixS2b)
      Line 0 $dX $WinInfo(0,p1) 0 $dX $WinInfo(0,p4) 0 LineS2b
      Line 1 $dX $WinInfo(1,p1) 0 $dX $WinInfo(1,p4) 0 LineS2b
      Line 2 $dX $WinInfo(2,p1) 0 $dX $WinInfo(2,p4) 0 LineS2b
      Line 3 $dX $WinInfo(3,p1) 0 $dX $WinInfo(3,p4) 0 LineS2b
   }

   if { $SNcommon(nLines) >= 4 } {
      GUIstateSet .gmMIDDLE.topA.setup PBUTTON normal
      GUIstateSet .gmMIDDLE.topA.plot PBUTTON disabled
   }

   set SNcommon(PlotUp)  1
}
