package provide ShockNormal 1.0

proc SNnvUpdate { Coefs Normals Color Stat StatInfo } {
    global RtoD PI PltInfo GphInfo guiAns

    upvar $Normals  nV
    upvar $Coefs    A
    upvar $StatInfo oP

    set cT [expr cos($A(1))]
    set sT [expr sin($A(1))]
    set cP [expr cos($A(0))]
    set sP [expr sin($A(0))]
    set nV(0) $cT
    set nV(1) [expr $cP * $sT]
    set nV(2) [expr $sP * $sT]
    set guiAns(X3) [format "%.3e" $nV(0)]
    set guiAns(Y3) [format "%.3e" $nV(1)]
    set guiAns(Z3) [format "%.3e" $nV(2)]
    if { $Color >= 0 } {
       set Th [expr acos($nV(0)) * $RtoD]
       set Ph [expr ($PI - atan2($nV(2), -$nV(1))) * $RtoD ]
       SetScreen 1 .gmCHISQ.plot
       set wN $PltInfo(10,wN)
       TextProp 12
       TexT $wN $Th $Ph 0.0 center "*" $GphInfo($Color) 0.0 PhTh
    }
    if { $Stat == 1 } {
       set dP  [expr sqrt($oP(7))]
       set dT  [expr sqrt($oP(10))]
       set Th [expr acos($nV(0)) * $RtoD]
       set Ph [expr ($PI - atan2($nV(2), -$nV(1))) * $RtoD ]
       set P(0) [expr $Ph / $RtoD] 
       set T(0) [expr $Th / $RtoD]
       set P(1) [expr ($Ph + $dP) / $RtoD] 
       set T(1) [expr ($Th + $dT)  / $RtoD]
       set P(2) [expr ($Ph - $dP) / $RtoD] 
       set T(2) [expr ($Th - $dT)  / $RtoD]

       set K 0
       for { set I 0 } { $I < 3 } { incr I } {
          set cP [expr cos($P($I))]
          set sP [expr sin($P($I))]
          for { set J 0 } { $J < 3 } { incr J ; incr K } {
             set cT [expr cos($T($J))]
             set sT [expr sin($T($J))]
             set X($K) $cT
             set Y($K) [expr $cP * $sT]
             set Z($K) [expr $sP * $sT]
          }
       }

       set sX 0.0
       set sY 0.0
       set sZ 0.0
       for { set I 0 } { $I < 9 } { incr I } {
          set Q [expr $X($I) - $X(0)]
          set sX [ expr $sX + $Q * $Q]
          set Q [expr $Y($I) - $Y(0)]
          set sY [ expr $sY + $Q * $Q]
          set Q [expr $Z($I) - $Z(0)]
          set sZ [ expr $sZ + $Q * $Q]
       }

       set guiAns(PHs3)  [format %.3e $dP]
       set guiAns(THs3)  [format %.3e $dT]
       set guiAns(Xs3)  [format %.3e [expr sqrt ($sX / 9.0)]]
       set guiAns(Ys3)  [format %.3e [expr sqrt ($sY / 9.0)]]
       set guiAns(Zs3)  [format %.3e [expr sqrt ($sZ / 9.0)]]
    }

    update
}
