package provide ShockNormal 1.0

proc SNmasvCal1 { } {
   global PI RtoD AvG VaR dMiN dMaX SNcommon

#  Set up the upstream and downstream varaibles according to Up.  BmU and
#  VmU are equivalent to Bm(0,3) and Vm(0,3) in Fortran code

   set UpS $SNcommon(Side)
   if { $SNcommon(Side) == 0 } { set DnS 1 } else { set DnS 0 }
   set BegD(0) 0
   set BegD(1) 8
   set BegV(0) 2
   set BegV(1) 10
   set BegM(0) 5
   set BegM(1) 13
   
   set fPI [expr 4.0 * $PI]
   set ePI [expr 8.0 * $PI]

   set dN(0) [expr $AvG(8) - $AvG(0)]
   TUvecMath AvG - AvG dV 10 2
   TUvecMath AvG - AvG dB 13 5

   TUvecMath AvG * AvG Part1 2 0 0 3 1
   TUvecMath AvG * AvG Part2 10 8 0 3 1
   TUvecMath Part2 - Part1 Part1
   TUvecMath Part1 / dN vT 0 0 0 3 1

   set RhoU [expr $SNcommon(Mass) * $AvG($BegD($UpS))]
   set RhoD [expr $SNcommon(Mass) * $AvG($BegD($DnS))]

   set BmU [TUvecMath AvG MAG AvG AvG $BegM($UpS)]
   set BmD [TUvecMath AvG MAG AvG AvG $BegM($DnS)]
   set AlfV [expr 1.0e-10 * $BmU / sqrt($fPI * $RhoU)]
      
   for { set Loop 0 } { $Loop < 3 } { incr Loop } {
      switch -exact -- $Loop {
         0  {   TUvecMath AvG CROSS AvG TmP 5 13
                TUvecMath dB CROSS TmP  Bn
                set Mag [TUvecMath Bn UNIT Bn E]
            }
         1  {   TUvecMath dB CROSS dV TmP
                TUvecMath dB CROSS TmP Bn
                set Mag [TUvecMath Bn UNIT Bn E]
            }
         2  {   set Mag [TUvecMath dV UNIT dV E ]
            }
      }

      set Th  [expr acos ($E(0))]
      set Ph  [expr $PI - atan2($E(2), -$E(1))]
      set E(0) [expr cos($Th) ]
      set E(1) [expr cos($Ph) * sin($Th) ]
      set E(2) [expr sin($Ph) * sin($Th) ]
      set Th [expr $Th * $RtoD]
      set Ph [expr $Ph * $RtoD]
      set BdN [expr [TUvecMath AvG DOT E TmP $BegM($UpS)] / $BmU ]

      if { $BdN > 1.0 } { set BdN 1.0 } elseif { $BdN < -1.0 } { set BdN -1.0 } 
      set ThBn [expr $RtoD * acos($BdN) ]
      set Vshk [TUvecMath vT DOT E TmP]
      set Vdn   [TUvecMath AvG DOT E TmP $BegV($UpS)]
      set AMach [expr abs($Vdn - $Vshk) / $AlfV ] 
      set VstrU  [expr 1.0e5 * ($Vdn - $Vshk) ]
      set VstrD  [expr 1.0e5 * ([TUvecMath AvG DOT E TmP $BegV($DnS)] - $Vshk)]
      set DpSm  [expr 1.0e-10 * ($BmU * $BmU - $BmD * $BmD) / $ePI] 
      set DpSk [expr $RhoU * $VstrU * $VstrU - $RhoD * $VstrD * $VstrD]
      set Dp   [expr ($DpSm + $DpSk) / 1.6022E-12 ]
   }
}
