# Get information on all of the data files, the format, and what data the
#   files contain.

package provide ShockNormal 1.0

proc SNguiData { } {
   global guiAns 

   set W .giDATA

   if { [winfo exists $W] == 0 } {
      toplevel $W
      wm title . "Data Defintion GUI"
 
      GUIFrame $W.top -1 pack|top||both
      for { set I 0 } { $I < 5 } { incr I } {
         GUIFrame $W.var$I -1 pack|top||both
      }

      set frId [list b c d e f]
      set fId [list A B C D E]
      set tM [list "Yr DoY Hr Mn S" "Yr Mo Dy Hr Mn Sc" "Yr Dy Mo Hr Mn Sc" \
                   "Mo Dy Yr Hr Mn S" "Dy Mo Yr Hr Mn Sc" ]
      set vR [list B V N Ti Te Tipp Tepp]
      set vU [list nT g /cm**3 /m**3 cm/s m/s km/s eV keV K mK ]

      set Row 0
      for { set I 0 ; set J 1 } { $I < 5 } { incr I ; incr J } {
         set iD [lindex $fId $I]
         set fR [lindex $frId $I]
         set Wn .giDATA.var$I
         GUILabel $Wn.lfn$iD "Data File $J" c grid|$Row|0|w
         GUIboxEntry $Wn.fn$iD grid|$Row|1|news||6 40 guiAns(fN$iD)
         incr Row
         GUILabel $Wn.ltm$iD "Time/Format" c grid|$Row|0|w
         GUIbuttonMenu $Wn.tM$iD $guiAns(tM$iD) grid|$Row|1|||2 $tM \
             "GUIoptsProcess $Wn.tM$iD guiAns(tM$iD) ALT "
         GUIboxEntry $Wn.tmf$iD grid|$Row|3|news||6 30 guiAns(tMf$iD)
 
         incr Row
         GUIblankRow $Wn $Row 1.0
         incr Row
	 set R $Row 
         incr Row
         GUILabel $Wn.lv$iD "Variable" c grid|$Row|0|w
         incr Row
         GUILabel $Wn.lfmt$iD "Units" c grid|$Row|0|w

         for { set K 1 } { $K <= 5 } { incr K } {
	    set Row $R
	    set vaR v${K}$iD
	    set unit u${K}$iD
            GUILabel $Wn.lv${K}1$iD $K c grid|$Row|$K|ew
            incr Row
            GUIbuttonMenu $Wn.$vaR $guiAns($vaR) grid|$Row|$K $vR \
                "GUIoptsProcess $Wn.$vaR guiAns($vaR) PRI "
            incr Row
            GUIbuttonMenu $Wn.$unit $guiAns($unit) grid|$Row|$K $vU \
                "GUIoptsProcess $Wn.$unit guiAns($unit) PRI "
         }
         if { $I != 4 } {
            incr Row
            GUIblankRow $Wn $Row 1.0
            incr Row
         }
      }

      set fId [list A B C D E]
      for { set I 0 } { $I < 5 } { incr I } {
         set iD [lindex $fId $I]
         for { set J 1 } { $J <= 5 } { incr J } {
            set Wn .giDATA.var$I.v${J}$iD
            bind  $Wn <Button-3> {GUIchgInfo %W " " }
         }
      }

      wm withdraw $W
      update
   }
}
