# This procedure sets up various grid definitions

package provide ShockNormal 1.0

proc SNgridSet { FmT gDef { vInfo A } } {
   global env SNcommon TimE

   upvar $gDef gI

   switch -exact -- $FmT {
      COMMON {
         upvar $vInfo vI
         set mID [list B V Ti Te N] 

# ESTIMAGE the smallest dT in all the data sets.  Do this by dividing the
#   number of points in a dataset by its time span in msec.  This assumes
#   that the data is all pretty much equal spaced throughout.

         set dT 1.0e9 
         for { set I 0 } { $I < 5 } { incr I } {
            set iD [lindex $mID $I]
            if ![info exists vI($iD)] { continue }
            set tB [lindex $vI($iD) 1]
            set tE [lindex $vI($iD) 2]
            set nP [expr $tE - $tB + 1]

            set Bt $TimE($tB)
            set Et $TimE($tE)
            set dH [expr ([lindex $Et 2] - [lindex $Bt 2]) * 3600000] 
            set dM [expr ([lindex $Et 3] - [lindex $Bt 3]) * 60000] 
            set dS [expr ([lindex $Et 4] - [lindex $Bt 4]) * 1000] 

            set T [expr $dH + $dM + $dS]
            if { $T < 0.0 } [expr $T + 86400000]
	    if { $I == 0 } { set tMF $T }
            set T [expr $T / double($nP)]
            if { $T < $dT } { set dT $T }

         }

# USE the dT to get the number of grids to divide the time spanned by the 
#    magnetic field data set.  We add dT to the total time since we will
#    center the beginning and ending time in the first and last grid.

         set nG [expr int(($tMF + $dT) / $dT)]

# SET up the MIN and MAX X values

         set tB [lindex $vI(B) 1]
         set tE [lindex $vI(B) 2]
         set Bt $TimE($tB)
         set Et $TimE($tE)
         set tEnd [expr [TUtimeConv $Bt $Et 0 SNcommon(Base)] + $dT / 2000.0]
         set tBeg [expr [TUtimeConv $Bt $Bt 0 SNcommon(Base)] - $dT / 2000.0]
         set SNcommon(BaseT) $TimE($tB)

# SET up the grid definition

         set gI(0) $tBeg      ; set gI(1) $tEnd
         set gI(2) -1.0       ; set gI(3) 1.0
         set gI(4) $nG        ; set gI(5) 1
         set gI(6) POINT      ;  set gI(7) POINT
         set gI(8) COLUMN
         set gI(9) KEEP
         set gI(10) NEW:ADD:END
         set gI(11) 1.0e20
         set gI(12) -1.0
         set gI(13) -1.0e20
         set gI(14) 1.0e20
         set gI(15) NO
         set gI(16) NO
      }
   }
}
