package provide ShockNormal 1.0

# THIS sets up the format to use when parsing the file.  It also returns
#   the number of variables which are being returned as well as the offset
#   to the first variable in a file line.

proc SNfileFormat { iD nVar vOff vList vInfo } {
   global guiAns 

   upvar $nVar  nV
   upvar $vOff  vO
   upvar $vList vL
   upvar $vInfo vI

# THIS is the format to use to read the time fields

   set rFmT [string trim $guiAns(tMf$iD)]

# GET the number of data fields and which variable fields are being 
#    returned in the file
# NOTE: B and V fields are triads and Tipp and Tepp are doublets.

   set tV 0
   set vL ""
   for { set J 1 } { $J <= 5 } { incr J } {
      if { [string length $guiAns(v${J}$iD)] > 0 } {
         set vR $guiAns(v${J}$iD)
	 if [string match Tipp $vR] {
             set vI(Ti) $guiAns(u${J}$iD)
         } elseif [string match Tepp $vR] {
             set vI(Te) $guiAns(u${J}$iD)
         } else { set vI($vR) $guiAns(u${J}$iD) }
         lappend vL $vR
         switch -exact -- $vR {
            B     { incr tV 3 }
	    V     { incr tV 3 }
	    Tipp  { incr tV 2 }
	    Tepp  { incr tV 2 }
	    Ti    { incr tV   }
	    Te    { incr tV   }
	    N     { incr tV   }
	 }
      }
   }
			     
   for { set I 0 } { $I < $tV } { incr I } { append rFmT " %e" }

# THIS is the number of variables to read in each line

   set nV [llength $vL]

# THIS is the location of the first data field

   if { $guiAns(tM$iD) == 0 } { set vO 5 } else { set vO 6 }

   return $rFmT
}

