package provide ShockNormal 1.0

# THIS procedure computes the upstream/downstream difference surface for
# the Rankine-Hugoniot equations using the selected data.  It is then
# plotted as a color encoded surface plot
#

proc SNdifSurface { } {

   global GphInfo PI RtoD guiAns SNcommon Xs Ys Zs nSp

# HERE give information on how to set up the  the surface mesh

   set gInfo(0) 0.0
   set gInfo(1) 180.0
   set gInfo(2) 0.0
   set gInfo(3) 360.0
   set gInfo(4) $guiAns(gT)
   set gInfo(5) $guiAns(gP)
   set gInfo(6) POINT
   set gInfo(7) POINT
   set gInfo(8) COLUMN
   set gInfo(9) KEEP
   set gInfo(10) NEW:ADD:END
   set gInfo(11) 10000.0
   set gInfo(12) -1.0
   set gInfo(13) 0.0
   set gInfo(14) 1.0e30
   set gInfo(15) NO
   set gInfo(16) YES

   set FirstXc [expr 180.0 / $guiAns(gT) / 2.0]
   set FirstYc [expr 360.0 / $guiAns(gP) / 2.0]
   set LastXc [expr 180.0 - 2.0 * $FirstXc]
   set LastYc [expr 360.0 - 2.0 * $FirstYc]

   set Timer 0
   set Color 0
   set TimerInc [expr $guiAns(dP)/360.0]
   set ColorInc [expr int(254.0 * $TimerInc)] 
   SNmeterPT $Timer 0 $Color
   if { ($SNcommon(SurGet) == 1) || ($SNcommon(ChgTm) == 1) } {
      set nSp 0
      set bP $FirstYc
      set bT $FirstXc
      for { set P $bP } { $P < 360.0 } { set P [expr $P + $guiAns(dP)] } {
         for { set T $bT } { $T < 180.0 } { set T [expr $T + $guiAns(dT)] } {
            set Xs($nSp) $T
            set Ys($nSp) $P
            set Zs($nSp) [SNrhEq $P $T ]
            incr nSp
         }
         set T [expr $T - $guiAns(dT)]
         if { $T < $LastXc } {
            set Xs($nSp) $LastXc
            set Ys($nSp) $P
            set Zs($nSp) [SNrhEq $P $LastXc ]
            incr nSp
         }

         set Timer [expr $Timer + $TimerInc]
         set Color [expr $Color + $ColorInc]
         SNmeterPT $Timer $nSp $Color
      }
      if { $P < $LastYc } {
         for { set T $bT } { $T < 180.0 } { set T [expr $T + $guiAns(dT)] } {
            set Xs($nSp) $T
            set Ys($nSp) $LastYc
            set Zs($nSp) [SNrhEq $LastYc $T ]
            incr nSp
         }
         set T [expr $T - $guiAns(dT)]
         if { $T < $LastXc } {
            set Xs($nSp) $LastXc
            set Ys($nSp) $LastYc
            set Zs($nSp) [SNrhEq $LastYc $LastXc ]
            incr nSp
         }
      }

# THE above makes sure that there are points along the grid minumum X and Y
#   axis.  Also want points to be along the max locations

      set SNcommon(SurGet) 0
      set SNcommon(TmGet)  0
   }

   TUdataGrid $nSp 1 Xs Xs 1 Ys Ys Zs Mesh mNorm gInfo

# NOW fill the mesh.  Filling only needs to be done if the surface
#   resolution does not match the mesh resolution that is if there are
#   unfilled grids in the mesh

   if ![string match $guiAns(sres) $guiAns(gres)] {

      set sInfo(0) 1

# COMPUTE an acceptable search radius (unit is grids)

#     set sInfo(1) [expr int(2.5 * $guiAns(dP) * $guiAns(gP) / 360.0)]

      set pV [expr 360.0 / $guiAns(dP)]
      set tV [expr 180.0 / $guiAns(dT)]
      set GpV [expr $guiAns(gP) * $guiAns(gP) / ($pV * $tV)]
      set sInfo(1) [expr int(ceil(sqrt (4.0 * $sInfo(0) * $GpV) / $PI) + 1)]
      if  { $sInfo(1) < 2 } { set sInfo(1) 2 }
      set sInfo(2) 4
      set sInfo(3) 2
      set sInfo(4) 0
      set sInfo(5) 0
      set sInfo(6) 0
      set sInfo(7) 0
      set sInfo(8) 1.0
      TUgridFill2D Mesh gInfo "" sInfo
   }

# FINALLY plot the surface

   set Theta(0) [expr acos($guiAns(X0)) * $RtoD]
   set Phase(0) [expr ($PI - atan2($guiAns(Z0), -$guiAns(Y0))) * $RtoD ]
   set Theta(1) [expr acos($guiAns(X1)) * $RtoD]
   set Phase(1) [expr ($PI - atan2($guiAns(Z1), -$guiAns(Y1))) * $RtoD ]
   set Theta(2) [expr acos($guiAns(X2)) * $RtoD]
   set Phase(2) [expr ($PI - atan2($guiAns(Z2), -$guiAns(Y2))) * $RtoD ]

   SNplotPT Mesh gInfo Phase Theta

# IF a surface normal has been selected then show it.

   if { $SNcommon(Phi) >= 0.0 } {
      TextProp 10
      TexT 10 $SNcommon(Theta) $SNcommon(Phi) 0.0 center \
                            "+" $GphInfo(Black) PhTh
   }
}
