package provide ShockNormal 1.0

#  INPUTS
#     Time         (fractions of day)
#     Density      (/cc)
#     MagField     (nanotesla)
#     Velocity     (km/sec)
#     Temperature  (eV)
#     N            Number of data points
#  OUTPUTS
#     None
#  RETURN - list 
#    Index 0  Number of data points in side 1 arrays (Min of Np1 and Np2)
#    Index 1  Number of data points in side 2 arrays (Min of Np1 and Np2)
#    Index 2  Number or data point in data array 
#    Index 3  Start time of Side 1 data (decimal day)
#    Index 4  End time of Side 1 data (decimal day)
#    Index 5  Start time of Side 1 data (decimal day)
#    Index 6  End time of Side 1 data (decimal day)
#
#  GLOBALS


proc SNdataStore { Time Den MagF Vel Temp N } {

   global SNcommon guiAns N1 T1 V1 B1 N2 T2 V2 B2
 
   upvar $Time Tm
   upvar $Den  De
   upvar $MagF Mf
   upvar $Vel  Ve
   upvar $Temp Tp

# IF all the times haven't been set give warning and return negative value

  if { $SNcommon(nLines) < 5 } { 
      set Msg "ERROR: Either the side1 or side2 to both time intervals\n\
               have not been defined.  Define them before running SetUp."
      GUImsgPopUp .ewin 30 5 $Msg
      return -1
  }
 
# SET the time base which is being used.

   set B $SNcommon(Base)

# ORDER out the selected times min to max. 

  if { $SNcommon(PixS1a) > $SNcommon(PixS1b) } {
     set TmP $SNcommon(PixS1a)
     set SNcommon(PixS1a) $SNcommon(PixS1b)
     set SNcommon(PixS1b) $TmP
     set TmP $SNcommon(TmS1a)
     set SNcommon(TmS1a) $SNcommon(TmS1b)
     set SNcommon(TmS1b) $TmP
     SNguiTime s1Ta $SNcommon(TmS1a) 1
     SNguiTime s1Tb $SNcommon(TmS1b) 1
  }
  if { $SNcommon(PixS2a) > $SNcommon(PixS2b) } {
     set TmP $SNcommon(PixS2a)
     set SNcommon(PixS2a) $SNcommon(PixS2b)
     set SNcommon(PixS2b) $TmP
     set TmP $SNcommon(TmS2a)
     set SNcommon(TmS2a) $SNcommon(TmS2b)
     set SNcommon(TmS2b) $TmP
     SNguiTime s2Ta $SNcommon(TmS2a) 1
     SNguiTime s2Tb $SNcommon(TmS2b) 1
  }

# COMPUTE the decimal time of the start and stop times on either side 
#     of the shock.

#set SNcommon(TmS1a) [list 1997 331 22 25 20 0] 
#set SNcommon(TmS1b) [list 1997 331 22 25 54 0] 
#set SNcommon(TmS2a) [list 1997 331 22 27 06 0] 
#set SNcommon(TmS2b) [list 1997 331 22 59 00 0]

   set Tdb [TUtimeConv $SNcommon(TBase) $SNcommon(TmS1a) 0 B]
   set Tsb [TUtimeConv $SNcommon(TBase) $SNcommon(TmS1b) 0 B]
   set Tse [TUtimeConv $SNcommon(TBase) $SNcommon(TmS2a) 0 B]
   set Tde [TUtimeConv $SNcommon(TBase) $SNcommon(TmS2b) 0 B]

#  GET the index of the beginning data point in side 1

   for {set Beg1 0 } { $Beg1 < $N } { incr Beg1 } {
      if { $Tm($Beg1) >= $Tdb } { break }
   }
 
#  AND now the index of the last data point in side 1

   for {set End1 $Beg1 } { $End1 < $N } { incr End1 } {
      if { $Tm($End1) >= $Tsb } { break }
   }
   if { $Tm($End1) > $Tsb } { incr End1 -1 }

#  THE index of the beginning data point in side 2
 
   for {set Beg2 $End1 } { $Beg2 < $N } { incr Beg2 } {
      if { $Tm($Beg2) >= $Tse } { break }
   }

#  AND the index of the last data point in side 2
 
   for {set End2 $Beg2 } { $End2 < $N } { incr End2 } {
      if { $Tm($End2) >= $Tde } { break }
   }
   if { ($Tm($End2) > $Tde) && ($End2 > 0) } { incr End2 -1 }

#  COMPUTE the total number of data points in sides 1 and 2.  While 
#    theoritically it is OK to have just one point on a side to prevent
#    complications later we always demand at least 2

   set Np1 [expr $End1 - $Beg1 + 1]
   if { $Np1 <= 1 } {
      set Msg "ERROR: Side1 time interval has $Np1 points.  Needs\n\
               a minimum of 2 points.  Widen the time interval."      
      GUImsgPopUp .ewin 55 5 $Msg
      return -1
   }

   set Np2 [expr $End2 - $Beg2 + 1]
   if { $Np2 <= 1 } {
      set Msg "ERROR: Side2 time interval has $Np2 points.  Needs\n\
               a minimum of 2 points.  Widen the time interval."      
      GUImsgPopUp .ewin 30 5 $Msg
      return -1
   }

#  STORE data from both sides 1 and 2 beginning with the points closest
#     to the shock and working outwards (that is beginning with the maximin
#     time on side 1 and minimum on side 2).  This is perfect storage for
#     mirror symmetry and permutation doesn't care how the data is stored.

# STORE side 1 data first.  It is stored in the reverse order, that is
#    from the shock moving away.

   set I 0
   set L 0
   set J $End1
   set K [expr 3 * $End1]
   for {set C 0} {$C < $Np1} { incr I;  incr C ; incr J -1 ; incr K -3} {
      set T1($I) $Tp($J)
      set N1($I) $De($J)
      set N $K
      for { set M 0 } { $M < 3 } { incr M ; incr L ; incr N } {
         set V1($L) $Ve($N)
         set B1($L) $Mf($N)
      }
      set bTm1 $Tm($J)
   }

   set SNcommon(nP1) $Np1

# NOW Store side 2 data.  It is stored in the foreward order

   set I 0
   set L 0
   set J $Beg2
   set K [expr 3 * $Beg2]
   for {set C 0} {$C < $Np2} { incr I;  incr C 1; incr J ; incr K 3 } {
      set T2($I) $Tp($J)
      set N2($I) $De($J)
      set N $K
      for { set M 0 } { $M < 3 } { incr M ; incr L ; incr N } {
         set V2($L) $Ve($N)
         set B2($L) $Mf($N)
      }
      set eTm2 $Tm($J)
   }

   set SNcommon(nP2) $Np2

   return 1
}
