package provide ShockNormal 1.0

#  This procedure merges the side1 and side 2 data sets according to
#    whether they being processed in MIRROR SYMMETRY or PERMUTATION
#    mode.  

proc SNdataMerge { } {
   global N1 T1 V1 B1 N2 T2 V2 B2 Np sP nN1 nP1 nV1 nB1 nN2 nP2 nV2 nB2  \
          SNcommon guiAns

   set cP [expr $SNcommon(Boltz) / $sP(3)]
   if [string match MIRRORED $guiAns(duse)] {
      set vP [expr 3 * $SNcommon(Pt1)]
      TUarrayMath  N1 / sP(0) nN1 $SNcommon(Pt1)
      TUarrayMath  N1 *  T1   nP1 $SNcommon(Pt1)
      TUarrayMath nP1 *  cP   nP1 $SNcommon(Pt1)
      TUarrayMath  N2 / sP(0) nN2 $SNcommon(Pt1)
      TUarrayMath  N2 *  T2   nP2 $SNcommon(Pt1)
      TUarrayMath nP2 *  cP   nP2 $SNcommon(Pt1)
      TUarrayMath  V1 / sP(1) nV1 $vP
      TUarrayMath  B1 / sP(2) nB1 $vP
      TUarrayMath  V2 / sP(1) nV2 $vP
      TUarrayMath  B2 / sP(2) nB2 $vP
   } else {
      set K 0
      set M 0
      for { set I 0 } {$I < $SNcommon(Pt1) } { incr I } {
         for { set J 0 } {$J < $SNcommon(Pt2) } { incr J ; incr K } {
            set nN1($K) [expr $N1($I) / $sP(0)]
            set nP1($K) [expr $N1($I) * $T1($I) * $cP]
            set nN2($K) [expr $N2($J) / $sP(0)]
            set nP2($K) [expr $N2($J) * $T2($J) * $cP]
            set X1 [expr $I * 3]
            set X2 [expr $J * 3]
            for { set L 0 } {$L < 3 } { incr L ; incr M ; incr X1 ; incr X2 } {
                set nV1($M) [expr $V1($X1) / $sP(1) ]
                set nB1($M) [expr $B1($X1) / $sP(2) ]
                set nV2($M) [expr $V2($X2) / $sP(1) ]
                set nB2($M) [expr $B2($X2) / $sP(2) ]
            }
         }
      }
   }
}
