package provide ShockNormal 1.0
 
proc SNasymSolve { }  {
   global PI RtoD sP SNcommon guiAns nN1 nV1 nB1 nP1 nN2 nV2 nB2 nP2 cRH  eRH

# COMPUTE the asymtotic states for all 4 of the normal solutions.  Begin
#   by computing the initial density guess which is the same for all
#   of the solutions. 

   set DGuess1 [TUarrayMath nN1 AVG nN1 nN1 $SNcommon(Pt1)]
   set DGuess2 [TUarrayMath nN2 AVG nN2 nN2 $SNcommon(Pt2)]

# NOW loop over the different solutions.  Note that if we have already done

   for { set I 0 } { $I < 4 } { incr I } {

# COMPUTE the RH constants
 
       SNasymRHcnst $I

# DO the fit to side 1.  Start iteration with density guess and set the
#   fit to iterate over the only parameter being fit

       set A(0) $DGuess1
       set Hold(0) 1

# SET the weighting to 1 and the yValues to 0 

       for { set J 0 } { $J < $SNcommon(Pt1) } { incr J } {
          set yV($J) 0.0
          set WgT($J) 1.0
       }

# MAKE the initial call to the NonLinear Least Squares fit to do all of the
#   one-time initializations

       set oP(0) -1.0
       TUdataNLinLSq yV WgT $SNcommon(Pt1) A Hold 1 SNasymSide1 oP

# INITIALIZE the MaxCnt.  This counts the number of iterations made and
#   gets us out of the loop at some predefined number of iterations whether
#   the minimum change in ChiSq has been reached or not.

       set MaxCnt  0

# NOW start iterating and continue until either a MaxCnt is reached or until
#    the search step size [op(0)] becomes overly large

       while { ($MaxCnt < $SNcommon(MaxIter)) && ($oP(0) < 10000.0) } {
          TUdataNLinLSq yV WgT $SNcommon(Pt1) A Hold 1 SNasymSide1 oP
          incr MaxCnt
       }

# ONE last call to the least squares routine to get the covariance and the
#    curvature matrices

       set oP(0) 0.0
       TUdataNLinLSq yV WgT $SNcommon(Pt1) A Hold 1 SNasymSide1 oP

# OK use the estimated density to get the RH model parameters on Side-1 of
#    the shock

       SNasymRHModel $oP(5) mRH1
       SNguiAsym mRH1 $I 1

# DO the fit to side 2.  Start iteration with density guess and set the
#   fit to iterate over the only parameter being fit

       set A(0) $DGuess2
       set Hold(0) 1

# SET the weighting to 1 and the yValues to 0 

      for { set J 0 } { $J < $SNcommon(Pt2) } { incr J } {
         set yV($J) 0.0
         set WgT($J) 1.0
      }

# MAKE the initial call to the NonLinear Least Squares fit to do all of the
#   one-time initializations

       set oP(0) -1.0
       TUdataNLinLSq yV WgT $SNcommon(Pt2) A Hold 1 SNasymSide2 oP

# INITIALIZE the MaxCnt.  This counts the number of iterations made and
#   gets us out of the loop at some predefined number of iterations whether
#   the minimum change in ChiSq has been reached or not.

       set MaxCnt  0

# NOW start iterating and continue until either a MaxCnt is reached or until
#    the search step size [op(0)] becomes overly large

       while { ($MaxCnt < $SNcommon(MaxIter)) && ($oP(0) < 10000.0) } {
          TUdataNLinLSq yV WgT $SNcommon(Pt2) A Hold 1 SNasymSide2 oP
          incr MaxCnt
       }

# ONE last call to the least squares routine to get the covariance and the
#    curvature matrices

       set oP(0) 0.0
       TUdataNLinLSq yV WgT $SNcommon(Pt2) A Hold 1 SNasymSide1 oP

# NOW use the estimated density to get the RH model parameters on Side-2 of
#    the shock

       SNasymRHModel $oP(5) mRH2
       SNguiAsym mRH2 $I 2

# SETUP normal vector

       set nV(0) $guiAns(X$I)
       set nV(1) $guiAns(Y$I)
       set nV(2) $guiAns(Z$I)

# COMPUTE some values to put the units back into the values

       set sC1 [expr $SNcommon(Mass) * $sP(0) * $sP(1) * $sP(1) * 1.0e10 ]
       set sC2 [expr $sP(2) * $sP(2) * 1.0e-10 / 8.0 / $PI ]

# COMPUTE the pressure difference.  This is always computed as being the
#   pressure on the high entropy side minus the pressure on the low 
#   entropy side.
 
       set Bp [TUvecMath mRH1 DOT mRH1 mRH1  4  4 ]
       set Vp [expr [TUvecMath mRH1 DOT nV nV 1 0] - $SNcommon(sV$I)]
       set mRH1(7) [expr $sC1 * $mRH1(0) * $Vp * $Vp + $Bp * $sC2]

       set Bp [TUvecMath mRH2 DOT mRH2 mRH2  4  4 ]
       set Vp [expr [TUvecMath mRH2 DOT nV nV 1 0] - $SNcommon(sV$I)]
       set mRH2(7) [expr $sC1 * $mRH2(0) * $Vp * $Vp + $Bp * $sC2]

       if { $SNcommon(Side) == 0 } {
          set dP [expr ($mRH1(7) - $mRH2(7)) / 1.6022e-12]
       } else { set dP [expr ($mRH2(7) - $mRH1(7)) / 1.6022e-12] }

       set guiAns(DP$I)  [format "%.3e" $dP]
       update
    }

    GUIstateSet .gmMIDDLE.topA.asym PBUTTON disabled

    return
}
