package provide ShockNormal 1.0
 
proc SNasymSide1 { dAdY Ops }  {
   global SNcommon mRH DeN1 dDeN1  nN1 nP1 nV1 nB1 

   upvar $dAdY dA
   upvar $Ops  oP

# SET twice the density step
 
   set N $oP(5)
   set TdA [ expr .02 * $N ]

# IF looking for the first RH value then solve for all of them and
# their derivitives. After that parcel them out as they are requested.
#
# THE RH values are stored in the array DeN1 and the derivitives are
# stored in the array dDeN1

   if { $oP(4) == 0 } {

# Get the RH model values

      SNasymRHModel $N mRH
      set plusN [expr 1.01 * $N] 
      SNasymRHModel $plusN pRH
      set negN [expr 0.99 * $N] 
      SNasymRHModel $negN nRH

      set J 0
      for { set I 0 } { $I < $SNcommon(Pt1) } { incr I ; incr J 3 } {
         set V(0) [expr $nN1($I) - $mRH(0)]
         TUvecMath nV1 - mRH V $J 1 1
         TUvecMath nB1 - mRH V $J 4 4
         set V(7) [expr $nN1($I) - $pRH(0)]
         TUvecMath nV1 - pRH V $J 1 8
         TUvecMath nB1 - pRH V $J 4 11
         set V(14) [expr $nN1($I) - $nRH(0)]
         TUvecMath nV1 - nRH V $J 1 15
         TUvecMath nB1 - nRH V $J 4 18
         set DeN1($I) [TUvecMath V MAG V V 0 0 0 7]
         set Pos [TUvecMath V MAG V V 7 7 0 7]
         set Neg [TUvecMath V MAG V V 14 14 0 7]
         set dDeN1($I) [expr ($Pos - $Neg)/$TdA]
      }
   }
   set dA(0) $dDeN1($oP(4))
   return $DeN1($oP(4))
}
