# THIS procedure combines the theta image with the reduced distribution
#   function image.  The distribution function image has already had phi
#   and the velocity integrated out and now just as dimensions of sensor
#
# INPUT:  thImG : theta ImG
#         dfImG : reduced distribution ImG
#         Back  : the returned ImG

package provide MOments_C 1.0

proc MOthdfImG { thImG dfImG Back } {
   global mANS

   upvar $thImG tH
   upvar $dfImG dF
   upvar $Back  rI

# THIS is the number of sensors in the images. 

   set nS $mANS(0,NSEN)

   for { set I 0 } { $I < $nS } { incr I } {
        set rI($I) [expr $tH($I) * $dF($I)]
   } 
}
