# THIS procedure combines a DF ImG with an Phase ImG
#
# INPUT:  ImGA : phase ImG
#         ImGB : dF ImG
#         Back : the returned ImG

package provide MOments_C 1.0

proc MOphidfImG { PhImG dFImG Back } {
   global mANS

   upvar $PhImG pH
   upvar $dFImG dF
   upvar $Back  rI

# THIS is the number of energy steps, sectors, and sensors used to build
#   the arrays.  The dF array is laid down in the order nE, nS, nT while
#   the pH array is laid down nE, nT.

   set nE $mANS(nE)
   set nS $mANS(Sector)
   set nT $mANS(0,NSEN)

   set N 0
   set pB 0
   set pE $nE
   for { set K 0 } { $K < $nS } { incr K ; incr pB $nE ; incr pE $nE } {
      for { set J 0 } { $J < $nT } { incr J } {
         for { set I $pB } { $I < $pE } { incr I ; incr N } {
            set rI($N) [expr $pH($I) * $dF($N)]
         }
      }
   }
}
