#  THIS procedure outputs the moments

package provide MOments 1.0

proc MOmomentsPr { Action } {
   global SInfo mANS

   switch -exact -- $Action {
      NEW {
         set OpS [list NO YES]

         if { [string length $mANS(OutRes)] > 0 } {
            if [catch {open $mANS(OutRes) w} mANS(oFd)] {
               puts stderr "UNABLE TO OPEN OUTPUT FILE: $mANS(OutRes)"
               set mANS(oFd) stderr
            }
         } else { set mANS(oFd) stderr }
         puts $mANS(oFd) "MOMENTS COMPUTATION RESULTS"
	 if { [string length $mANS(MOMENTS)] > 0 } {
            set S UD[lindex $mANS(MOMENTS) 0] 
            puts $mANS(oFd) "SOURCE:   $mANS($S,P).$mANS($S,M).$mANS($S,E).$mANS($S,I).$mANS($S,V)"
         }
	 if { [string length $mANS(POTENTIAL)] > 0 } {
	    set sN [lindex $mANS(POTENTIAL) 0]
	    if [string match UDF $mANS($sN,sBase)] {
               set S UD[lindex $mANS(POTENTIAL) 0] 
               puts $mANS(oFd) "POT-UDF: $mANS($S,P).$mANS($S,M).$mANS($S,E).$mANS($S,I).$mANS($S,V)"
            } else { 
	       puts $mANS(oFd) "POT-CAA: $mANS($sN,caaFn)"
	       set VaRs($sN)  [list "S/C Potential"]
	       set UniTs($sN) [list volts]
            }
         }

	 if { [string length $mANS(MAGFIELD)] > 0 } {
	    set sN [lindex $mANS(MAGFIELD) 0]
	    if [string match UDF $mANS($sN,sBase)] {
               set S UD[lindex $mANS(MAGFIELD) 0] 
               puts $mANS(oFd) "MF-UDF:  $mANS($S,P).$mANS($S,M).$mANS($S,E).$mANS($S,I).$mANS($S,V)"
            } else { 
	       puts $mANS(oFd) "MF-CAA:  $mANS($sN,caaFn)"
	       set VaRs($sN)  [list Bx By Bz]
	       set UniTs($sN) [list nT nT nT]
            }
         }

         set nS [llength $mANS(INFO)]
         for { set I 0 } { $I < $nS } { incr I } {
            set S UD[lindex $mANS(INFO) $I] 
           puts $mANS(oFd) "INFO $I:   $mANS($S,P).$mANS($S,M).$mANS($S,E).$mANS($S,I).$mANS($S,V)"
	  }

	 if !$mANS(appE) { set appE PREPOT } else { set appE POSTPOT }
         puts $mANS(oFd) "SPECIES INFORMATION"
         puts $mANS(oFd) "   SPECIES: $mANS(Species)"
         puts $mANS(oFd) "   AMU:     $mANS(sAMU)"
         puts $mANS(oFd) "INTEGRATION LIMITS"
         puts $mANS(oFd) "    ENERGY: $mANS(bEv) To $mANS(eEv) eV  ($appE)"
         puts $mANS(oFd) "    PHI:    $mANS(bPh) To $mANS(ePh) degrees"
         puts $mANS(oFd) "    THETA:  $mANS(bTh) To $mANS(eTh) degrees"
         puts $mANS(oFd) "PHI INFORMATION"
	 if { $mANS(cFmT) == 0 } { set Op FIXED } else { set Op LINEAR }
         puts $mANS(oFd) "    INTEGRATION TYPE: $Op"
         puts $mANS(oFd) "    OFFSET:           $mANS(pOff) Deg"

         puts $mANS(oFd) "SATELLITE POTENTIAL INFORMATION"
         if { [llength $mANS(POTENTIAL)] == 0 } {
            puts $mANS(oFd) "    NO POTENTIAL DATA UNUSED"
            puts $mANS(oFd) "    OFFSET: $mANS(pVOff) eV"
         } else { 
            puts $mANS(oFd) "    OFFSET: $mANS(pVOff) eV"
            puts $mANS(oFd) "    INCLUDE STEP WITH POTENTIAL: [lindex $OpS $mANS(pVExt)]"
         }
         puts $mANS(oFd) "INITIAL POSITIONING IN FILE"
         puts $mANS(oFd) "    $mANS(BegFlg)"


         set CnT 0
	 set W .moMask.body.list
	 if ![winfo exists $W] { MOguiMasks 1 }
	 set nF [$W index end]
	 for { set Q 0 } { $Q < $nF } { incr Q } {
	    set LiNe [$W get $Q]
	    scan $LiNe "%s %f %f %f %f %f %f %f %s" \
	          Type eB eE pB pE tB tE pM Inv

	    set mA  [string match MASK_A $Type]
	    set mRH [string match MASK_RH $Type]
	    set mRT [string match MASK_RT $Type]

            if { $mA || $mRH || $mRT } { 
               puts $mANS(oFd) "MASK DEFINITION $CnT"
               puts $mANS(oFd) "    TYPE:       $Type"
               puts $mANS(oFd) "    PHI LOW:    $pB Deg"
               puts $mANS(oFd) "    PHI HIGH:   $pE Deg"
               puts $mANS(oFd) "    EV LOW:     $eB eV"
               puts $mANS(oFd) "    EV HIGH:    $eE eV"
               puts $mANS(oFd) "    THETA LOW:  $tB Deg"
               puts $mANS(oFd) "    THETA HIGH: $tE Deg"
               puts $mANS(oFd) "    INVERT      $Inv"
	       incr CnT
            }
         }

	 set CnT 0
	 for { set Q 0 } { $Q < $nF } { incr Q } {
	    set LiNe [$W get $Q]
	    scan $LiNe "%s %f %f %f %f %f %f %f" Type eB eE pB pE tB tE pM

	    set cA  [string match CLIP_A $Type]
	    set cR [string match CLIP_R $Type]

            if { $cA || $cR } { 
               puts $mANS(oFd) "CLIP DEFINITION $CnT"
               puts $mANS(oFd) "    TYPE:       $Type"
               puts $mANS(oFd) "    PHI LOW:    $pB Deg"
               puts $mANS(oFd) "    PHI HIGH:   $pE Deg"
               puts $mANS(oFd) "    EV LOW:     $eB eV"
               puts $mANS(oFd) "    EV HIGH:    $eE eV"
               puts $mANS(oFd) "    THETA LOW:  $tB Deg"
               puts $mANS(oFd) "    THETA HIGH: $tE Deg"
               puts $mANS(oFd) "    \%MAX:      $pM"
	       incr CnT
            }
         }

	 if $mANS(DoCor) {
            puts $mANS(oFd) "LOW LEVEL CORRECTIONS APPLIED"
            puts $mANS(oFd) "   CORRECTION FILE: $mANS(cFile)" 
         }
         
         puts $mANS(oFd) "MOMENTS RETURNED: "
         puts $mANS(oFd) "  DENSITY (/m**3)"
         puts $mANS(oFd) "  VELOCITY (X,Y,Z) (m/s)" 
         puts $mANS(oFd) "  VELOCITY**2 (XX, XY, XZ, YY, YZ, ZZ) (m**2/s**2)"
         puts $mANS(oFd) "  VELOCITY**3 (XXX, XXY, XXZ, XYY, XYZ, XZZ"
         puts $mANS(oFd) "               YYY, YYZ, YZZ, ZZZ) (m**3/s**3)"
	 puts $mANS(oFd) "EXTRA DATA RETURNED"

	 set nS [llength $mANS(SrcList)]
	 set tL ""
         for { set I 0 } { $I < $nS } { incr I } {
	    lappend tL [list [lindex $mANS(iOffsets) $I] \
	               [lindex $mANS(SrcList) $I] ]
         }
	 set oL [lsort -integer -increasing -index 0 $tL]

         for { set I 0 } { $I < $nS } { incr I } {
	    set lV [lindex $oL $I]
	    set P [lindex $lV 0]
	    if { $P >= 0 } { 
	       set S [lindex $lV 1]
	       if [string match UDF $mANS($S,sBase)] {
	          set nM  [llength $mANS($S,sNum)]
                  for { set J 0 } { $J < $nM } { incr J ; incr P } {
                     set sN [lindex $mANS($S,sName) $J]
                     set uN [lindex $mANS($S,uName) $J]
                     puts $mANS(oFd) "  EXTRA $P - $sN ($uN) "
                  }
               } else { 
	          set nM [llength $VaRs($S)]
                  for { set J 0 } { $J < $nM } { incr J ; incr P } {
                     set sN [lindex $VaRs($S) $J]
                     set uN [lindex $UniTs($S) $J]
                     puts $mANS(oFd) "  EXTRA $P - $sN ($uN) "
                  }
               }
            }
         }
	 puts $mANS(oFd) "BEGIN"
      }

      ADD {
         if { $mANS(Density) >= 0.0 } { 
            set bT [TUtimeFmt 0 $mANS(bY) $mANS(bD) $mANS(bM)]
            set eT [TUtimeFmt 0 $mANS(eY) $mANS(eD) $mANS(eM)]
            puts $mANS(oFd) "$bT $eT \
                  [format "%.7e %.7e %.7e %.7e %.7e %.7e %.7e %.7e %.7e \
                           %.7e %.7e %.7e %.7e %.7e %.7e %.7e %.7e %.7e \
                           %.7e %.7e %.7e %.7e %.7e %.7e %.7e %.7e %.7e \
			   %.7e %.7e %.7e" \
                           $mANS(Density) $mANS(Vx) $mANS(Vy) $mANS(Vz) \
                           $mANS(Vx2) $mANS(VxVy) $mANS(VxVz) $mANS(Vy2) \
			   $mANS(VyVz) $mANS(Vz2) $mANS(Vx3) $mANS(Vx2Vy) \
			   $mANS(Vx2Vz) $mANS(VxVy2) $mANS(VxVyVz) \
			   $mANS(VxVz2) $mANS(Vy3) $mANS(Vy2Vz) $mANS(VyVz2) \
                           $mANS(Vz3) $mANS(FV0) $mANS(FV1) $mANS(FV2) \
			   $mANS(FV3) $mANS(FV4) $mANS(FV5) $mANS(FV6) \
			   $mANS(FV7) $mANS(FV8) $mANS(FV9) ]"
         }
      }

      END {
        close $mANS(oFd)
      }
   }
}
