#THIS procedure builds the velocity integrals.  Integrals are of the form  
#
#           [High^(Order+2) - Low^(Order+2)]/[Order + 3]
#
# INPUT:  Low   : array of the lower edges of the phase bins
#         High  : array of the upper edges of the phase bins
#         Back  : the returned integrated array
#         Order : the order of the integral less 2

package provide MOments_C 1.0

proc MOmassintVel { Low High Back Order } {
   global mANS

   upvar $Low  Lw
   upvar $High Hi
   upvar $Back rI

# THIS is the order of the integral.  The plus two comes from the fact
#   that there is a v squared in the integral which came from the
#   conversion to spherical coordinates

   incr Order 2

# SET up the sign to use when doing the integration.  This depends on
#   whether we are integrating low to hi or hi to low.
  
   if { $Lw(0) < $Hi(0) } { set SgN + } else { set SgN - }

# DO the integrations

   for { set I 0 } { $I < $mANS(nE) } { incr I } {
      set H 1.0
      set L 1.0
      set C  [expr $Order + 1]
      for { set J 0 } { $J < $C } { incr J } {
         set L [expr $L * $Lw($I)]
         set H [expr $H * $Hi($I)]
      }
      set rI($I) [expr ${SgN}( $H - $L ) / double($C) ]
   }
}
