# THIS procedure integrates out the velocity component in the ImG array. 
#   The phi component has already been integrated out.  The array at 
#   this point has dimensions nE x Sensor.

package provide MOments_C 1.0

proc MOintVel { ImG Back } {
   global mANS 

   upvar $ImG  V
   upvar $Back rI

   for { set I 0 } { $I < $mANS(0,NSEN) } { incr I } {
      set rI($I) 0.0
      set J [expr $I * $mANS(nE) + $mANS(bEP)]
      set JEnD [expr $I * $mANS(nE) + $mANS(eEP)]
      for { } { $J <= $JEnD } { incr J } {
         set rI($I) [expr $rI($I) + $V($J)]
      }
   }
}
