#  THIS procedure reads in all the data necessary to do a single inversion.
#    The ancillary data is located according to the begin time og the EUV 
#    image being inverted.

package provide MOments 1.0

proc MOacqTheta { } {
   global mANS thBImG thEImG RtoD

   set KeY $mANS([lindex $mANS(MOMENTS) 0],KeY)

# FILL in the theta angles.  The information comes from the VIDF.  
#   Loop over the defined constants.  We are looking for the fillowing:
#   cID = 1: Center elevation angles
#   cID = 4: Start elevation angles
#   cID = 5: Stop elevation angles
#   cID = 9: Elevation FWHM

   set iD1 0 ; set iD4 0 ; set iD5 0 ; set iD9 0
   ReadVIDF $KeY 0 NUMCONSTS 0 0 0 NConst
   for {set I 0} {$I < $NConst} { incr I } {
      ReadVIDF $KeY 0 CONSTID $I 0 0 cID
      switch -exact -- $cID {
         1   {  
            ReadVIDF $KeY 0 CONSTSCA $I 0 -1 Sc 1
            ReadVIDF $KeY 0 CONST $I 0 -1 V 1
            UDFScale Sc V CenTer 1
            set iD1 1
            unset Sc
            unset V
         }
         4   {  
            ReadVIDF $KeY 0 CONSTSCA $I 0 -1 Sc 1
            ReadVIDF $KeY 0 CONST $I 0 -1 V 1
            UDFScale Sc V LoW 1
            set iD4 1
            unset Sc
            unset V
         }
         5   {  
            ReadVIDF $KeY 0 CONSTSCA $I 0 -1 Sc 1
            ReadVIDF $KeY 0 CONST $I 0 -1 V 1
            UDFScale Sc V HigH 1
            set iD5 1
            unset Sc
            unset V
         }
         9   {  
            ReadVIDF $KeY 0 CONSTSCA $I 0 -1 Sc 1
            ReadVIDF $KeY 0 CONST $I 0 -1 V 1
            UDFScale Sc V FwHm 1
            set iD9 1
            unset Sc
            unset V
         }
      }
   }

# OK we have what information we are going to get now lets hope we have
#   enough to build the start/stop array.

   if { $iD4 && $iD5 } {
      set nS [array size LoW] 
      for { set I 0 } { $I < $nS } { incr I } {
         set thBImG($I) $LoW($I)
         set thEImG($I) $HigH($I)
      } 
   } elseif { $iD1 && $iD9 } {
      set nS [array size FwHm] 
      for { set I 0 } { $I < $nS } { incr I } {
         set dT [expr FwHM($I) / 2.0]
         set thBImG($I) [expr $CenTeR($I) - $dT]
         set thEImG($I) [expr $CenTeR($I) + $dT]
      } 
   } elseif { $iD4 && $iD9 } {
      set nS [array size FwHm] 
      for { set I 0 } { $I < $nS } { incr I } {
         set thBImG($I) $LoW($I)
         set thEImG($I) [expr $LoW($I) + $FwHm($I)]
      } 
   } elseif { $iD5 && $iD9 } {
      set nS [array size FwHm] 
      for { set I 0 } { $I < $nS } { incr I } {
         set thBImG($I) [expr $HigH($I) - $FwHm($I)]
         set thEImG($I) $HigH($I)
      } 
   } else {
      puts stderr "NO THETA INFORMATION"
      exit
   }

# NOTE that in converting the theta angles to radians that we also flip
#    them about 180 degrees so that they reference the flow direction and
#    not the instrument look direction

   for { set I 0 } { $I < $nS } { incr I } {
      set thBImG($I) [expr (180.0 - $thBImG($I)) / $RtoD ]
      set thEImG($I) [expr (180.0 - $thEImG($I)) / $RtoD ]
   }
}
