# THIS procedure acquires the measurements from a single CAA source during
#   the duration of one of the moments computation.

# IN the procedure:
#   tChk == 0 : measurement time is earlier than the time of the moments
#   tChk == 1 : measurement time is within than the time of the moments
#   tChk == 2 : measurement time is later than the time of the moments

package provide MOments 1.0

proc MOacqCAA { sN Src rV } {
   global mANS

   upvar $rV V

# IF we have hit the end of file for this data then return no values
#   and let the calling routine determine what to do

   if $mANS($sN,EOF) { return 0 }

# THIS is the bad value removal condition and value

   if [info exists mANS($sN,bVal)] {
      set Cond [lindex $mANS($sN,bVal) 0]
      set bV [lindex $mANS($sN,bVal) 1]
   } else { set Cond > ; set bV $mANS(Bad) }

   if [string match MAGFIELD $Src] {
      set FmT "%d-%d-%dT%d:%d:%fZ,%f,%f,%f,%f,"
      set rCmD {scan $LiNe $FmT bY bMo bD bH bM bS _T1 \
                     mANS($sN,MF0) mANS($sN,MF1) mANS($sN,MF2) }
      set nS 3
   } else {
      set FmT "%d-%d-%dT%d:%d:%fZ,%f,"
      set rCmD {scan $LiNe $FmT bY bMo bD bH bM bS mANS($sN,cV0)}
      set nS 1
   } 

   # INITIALIZE the normalization and values for the sensors 

   for { set I 0 } { $I < $nS } { incr I } {
      set Norm($I) 0.0
      set V($I)  0.0
   }


   if { $mANS($sN,tChk) == -100 } { set mANS($sN,tChk) [MOtimeCheck $sN Fr] }


# CHECK to see where this sensor stands with respect to the time of the
#   current moment calculation

   if { $mANS($sN,tChk) > 1 } {
      set mANS($sN,tChk) [MOtimeCheck $sN Fr]
      if { ($mANS($sN,tChk) == 1) || ($mANS($sN,tChk) == 3) } {
         for { set I 0 } { $I < $nS } { incr I } {
            set V($I) [expr $Fr * $mANS($sN,cV$I)]
            set Norm($I) $Fr
         }
      } elseif { $mANS($sN,tChk) == 2 } {
         for { set I 0 } { $I < $nS } { incr I } {
            set V($I) $mANS($sN,cV$I)
            set Norm($I) 1.0
         }
      }
   }

# THIS is the acquisition loop.  Acquire the sensors so long as their 
#   center time is within the time of the moments computation.  Forward
#   on the last sensor

   while { $mANS($sN,tChk) < 2 } {
      set EOF [gets $mANS($sN,fd) LiNe] 
      if { $EOF <= 0 } { set mANS($sN,EOF) 1 ; return 0 }
      eval $rCmD

      set YD [TUtimeFmt 5 $bY $bMo $bD]
      scan $YD "%4d%3d" bY bD
      set bMs [expr int(($bH * 3600 + $bM * 60 + $bS) * 1000)]

      set mANS($sN,bfYr) $bY
      set mANS($sN,efYr) $bY
      set mANS($sN,bfDy) $bD
      set mANS($sN,efDy) $bD
      set mANS($sN,bfMs) $bMs
      set mANS($sN,efMs) [expr $bMs + $mANS($sN,dT)]
      if { $mANS($sN,efMs) > 86400000 } {
         set mANS($sN,efMs) [ expr $mANS($sN,efMs) - 86400000]
         incr mANS($sN,efDy) 
	 if { $mANS($sN,efDy) > [TUyearLeap $mANS($sN,efYr)] } {
            set mANS($sN,efDy) 1 
            incr mANS($sN,efYr) 
         }
      }

      set mANS($sN,tChk) [MOtimeCheck $sN Fr]

      if { ($mANS($sN,tChk) == 1) || ($mANS($sN,tChk) == 3) } { 
         if [string match ">" $Cond] {
            for { set I 0 } { $I < $nS } { incr I } { 
	       if { $mANS($sN,cV$I) < $bV } {
                  set V($I) [expr $V($I) + $Fr * $mANS($sN,cV$I)]
                  set Norm($I) [expr $Norm($I) + $Fr]
               }
            }
         } else {
            for { set I 0 } { $I < $nS } { incr I } { 
	       if { $mANS($sN,cV$I) > $bV } {
                  set V($I) [expr $V($I) + $Fr * $mANS($sN,cV$I)]
                  set Norm($I) [expr $Norm($I) + $Fr]
               }
            }
	 }
      }
   }

   if { $Norm(0) > 0 } {
      for { set I 0 } { $I < $nS } { incr I } { 
          set V($I) [expr $V($I) / $Norm($I)] 
      }
   } else {
      if [string match POTENTIAL $Src] { 
         for { set I 0 } { $I < $nS } { incr I } { set V($I) $mANS($sN,cV$I) }
      } else {
         for { set I 0 } { $I < $nS } { incr I } { set V($I) $mANS(Bad) }
      }
   }

   return $nS
}
