/*  The C equivalent of MOceldfImG. It consists a straight C interface.     */ 
/*                                                                          */
/*  There are 5 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Velocity Image                                             */
/*     OBJV[2]:  Distribution Function Image                                */
/*     OBJV[3]:  Return array                                               */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TmomentAnsi.h"
#include "TutilAnsi.h"

int VelDfImg (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   ReaL_8 V, dF, vE; 
   ByTe_4 I, J, N;
   int    nE, nS;

   char Index[10];
   char *vName, *dName, *rName;
   int Flg = TCL_LEAVE_ERR_MSG;

   Tcl_Obj *rVO;
  
/* MAKE sure that all the IO parameters are present                      */

   if (objc != 4 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: MOveldfImg vImG dfImG Back");
     return TCL_ERROR;
   }

/* GET the global information we'll need                                 */

   Tcl_UpVar(tI, "#0", "mANS", "mAnS", 0);
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "0,NSEN", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &nS);
   }
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "nE", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &nE);
   }

   vName = Tcl_GetStringFromObj(objv[1], (int *)0);
   dName = Tcl_GetStringFromObj(objv[2], (int *)0);
   rName = Tcl_GetString(objv[3]);

   N = 0;
   for (J = 0; J < nS; ++J) {
      for (I = 0; I < nE; ++I, ++N) {
         sprintf(Index, "%d", I);
	 rVO = Tcl_GetVar2Ex(tI, vName, Index, Flg);
	 Tcl_GetDoubleFromObj (tI, rVO, &vE);
         sprintf(Index, "%d", N);
	 rVO = Tcl_GetVar2Ex(tI, dName, Index, Flg);
	 Tcl_GetDoubleFromObj (tI, rVO, &dF);

         V = vE * dF;

	 rVO = Tcl_DuplicateObj(rVO);
	 Tcl_SetDoubleObj (rVO, V);
	 Tcl_SetVar2Ex(tI, rName, Index, rVO, Flg);
      }
   }

   return TCL_OK;
}
