/*  The C equivalent of MOintVel. It consists a straight C interface.       */ 
/*                                                                          */
/*  There are 5 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Input Image                                                */
/*     OBJV[2]:  Return array                                               */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TmomentAnsi.h"
#include "TutilAnsi.h"

int IntVel (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   ReaL_8 V, R; 
   ByTe_4 I, J, N, jEnD;
   int    nE, nS, bEP, eEP;

   char Index[10];
   char *iName, *rName;
   int Flg = TCL_LEAVE_ERR_MSG;

   Tcl_Obj *rVO, *rV1;
  
/* MAKE sure that all the IO parameters are present                      */

   if (objc != 3 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: MOveldfImg vImG dfImG Back");
     return TCL_ERROR;
   }

/* GET the global information we'll need                                 */

   Tcl_UpVar(tI, "#0", "mANS", "mAnS", 0);
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "0,NSEN", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &nS);
   }
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "nE", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &nE);
   }
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "bEP", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &bEP);
   }
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "eEP", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &eEP);
   }

   iName = Tcl_GetStringFromObj(objv[1], (int *)0);
   rName = Tcl_GetStringFromObj(objv[2], (int *)0);
   rV1 = Tcl_NewObj();

   N = 0;
   for (I = 0; I < nS; ++I) {
      R = 0.0;
      J = I * nE + bEP;
      jEnD = I * nE + eEP;
      for ( ; J <= jEnD; ++J) {
         sprintf(Index, "%d", J);
         rVO = Tcl_GetVar2Ex(tI, iName, Index, Flg);
         Tcl_GetDoubleFromObj (tI, rVO, &V);
	 R += V;
      }

      sprintf(Index, "%d", I);
      rV1 = Tcl_DuplicateObj(rV1);
      Tcl_SetDoubleObj (rV1, R);
      Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
   }

   return TCL_OK;
}
