/*  The C equivalent of MOintTheta. It consists a straight C interface.     */ 
/*                                                                          */
/*  There are 5 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Input Image                                                */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TmomentAnsi.h"
#include "TutilAnsi.h"

int IntTh (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   ReaL_8 V, R; 
   ByTe_4 I;
   int    nS;

   char Index[10];
   char *iName;
   int Flg = TCL_LEAVE_ERR_MSG;

   Tcl_Obj *objPtr, *rVO;
  
/* MAKE sure that all the IO parameters are present                      */

   if (objc != 2 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: MOintTheta In");
     return TCL_ERROR;
   }

/* GET the global information we'll need                                 */

   Tcl_UpVar(tI, "#0", "mANS", "mAnS", 0);
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "0,NSEN", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &nS);
   }


   iName = Tcl_GetStringFromObj(objv[1], (int *)0);

   R = 0.0;
   for (I = 0; I < nS; ++I) {
       sprintf(Index, "%d", I);
       rVO = Tcl_GetVar2Ex(tI, iName, Index, Flg);
       Tcl_GetDoubleFromObj (tI, rVO, &V);
       R += V;
   }

   objPtr = Tcl_GetObjResult(tI);
   Tcl_SetDoubleObj (objPtr, R);
   return TCL_OK;
}
