package provide TclGUI 1.0

# THIS procedure will pass back requested option parameters
#    
#  GiveBack 
#     OPTV:  Wants an option value.  Input 1 is an option value;
#            Input2 identifies this as a PRI or ALT value; and
#            Input3 wants the either the PRI or ALT value returned.

proc GUIoptsInfo { W GiveBack Input1 { Input2 "" } { Input3 "" } } { 
  global GUIoptPri GUIoptAlts 

#  GET the option labels if we are using ALT to get PRI or vice versa

   set ReT ""

   if [info exists GUIoptPri($W)] {
      set PriOpts $GUIoptPri($W)
      if ![string match $Input2 $Input3] {
         if { [llength $PriOpts] == 0 } { set XChg 0 } else { set XChg 1 }
      } else { set XChg 0 }
   } else {
      set Wm $W.menu
      if [winfo exists $Wm] {
         if ![string match $Input2 $Input3] {
            set LastI [$Wm index end]
            set PriOpts ""
            if ![string match none $LastI] { 
               for { set I 0 } { $I <= $LastI } { incr I } {
                  lappend PriOpts [$Wm entrycget $I -label]
               }
               set XChg 1
            } else { set XChg 0 }
         } else { set XChg 0 }
      } else { return $ReT }
   }

   switch -exact -- $GiveBack {
      OPTV {
         if !$XChg {
            set ReT $Input1
         } else {
            if [string match $Input2 PRI] {
               set P [lsearch -exact $PriOpts $Input1 ] 
               if { $P >= 0 } {
                  if { [llength $PriOpts] == 0 } {
                     set ReT $P
                  } else { set ReT [lindex $GUIoptAlts($W) $P] } 
               }
            } else {
               if { [llength $GUIoptAlts($W)] == 0 } {
                  set P $Input1
               } else { set P [lsearch -exact $GUIoptAlts($W) $Input1 ] } 

               if { $P >= 0 } { set ReT [lindex $PriOpts $P] } 
            }
         }
      }
   }

   return $ReT
}
