package provide TclGUI 1.0

# Prevents menu column lengths from being greater than MaxInCol.  
# If a menu list is greater then it suggests the number of items
# to be put into each lengh of a multi-column list

proc GUImenuCLen { Len } {
   global MaxInCol

   if { [info exists MaxInCol] == 0 } { set MaxInCol 15 }

   set CL $MaxInCol
   if { $Len > $MaxInCol } {
      set C1 [expr int ($Len / $MaxInCol) ] 
      set R1 [expr $Len % $MaxInCol ] 
      if { $R1 != 0 } { 
         incr C1 
         set C2 [expr int ($Len / $C1) ] 
         set R2 [expr $Len % $C1 ] 
         if { $R2 != 0 } { 
            incr C2 
            set R3 [expr $Len % $C2 ] 
            set D1 [expr $MaxInCol - $R1]
            set D2 [expr $C2 - $R3]
            if {$D2 < $D1 } { set CL $C2 }
         } else { set CL $C2 }
      }
   } 
   return $CL
}
