package provide TclGUI 1.0

proc GUImakeFont { font { Base "" } { bTag NO } { TaG ""} } { 
   global env Prefs

   upvar $font FonT

# SET up the default font.  This will depend on base.  If its empty then
#   its build according to the user preferences otherwise its based on
#   a previously defined font.

   set deF(2) normal
   set deF(3) roman
   set deF(4) false

   if { [string length $Base] == 0 } {
      set deF(0) $Prefs(Font)
      set deF(1) $Prefs(FontSize)
   } else {
      set fC [lindex [$Base configure -font] 4]
      set fCLen [llength $fC]
      for { set I 0 ; set J 1 } { $I < $fCLen } { incr I 2 ; incr J 2 } {
         set iD [lindex $fC $I]
	 switch -exact -- $iD {
	    -family    { set deF(0) [lindex $fC $J] }
	    -size      { set deF(1) [lindex $fC $J] }
	    -weight    { set deF(2) [lindex $fC $J] }
	    -slant     { set deF(3) [lindex $fC $J] }
	    -underline { set deF(4) [lindex $fC $J] }
	 }
      }
   }

# NOW build the font.  All empty fields are given the default value.

   set fO ""
   set Field [list family size weight slant underline]
   for { set I 0 } { $I < 5 } { incr I } {
      set oP [lindex $FonT $I]
      if { [string length $oP] == 0 } { set oP $deF($I) }
      lappend fO -[lindex $Field $I] $oP
   }

# IF we need to build a tag for the font do it now.

   if [string match YES $bTag] {
      upvar $TaG tG
      set tG ""
      for { set I 0 } { $I < 5 } { incr I } {
         set oP [lindex $FonT $I]
         if { [string length $oP] == 0 } { set oP $deF($I) }
	 if { $I < 2 } {
            append tG $oP
          } else { append tG [string index $oP 0] }
      }
   } 

   set FonT $fO
}
