package provide TclGUI 1.0

# THIS procedure converts colors from RGB to HEX and vice versa.  It will
#  also convert 16 bit HEX colors to 32 bit HEX colors
#
# NOTE that the HEX colors both in and out have the preceeding pound sign

#  FmT is either RGB or HEX and indicates the color being converted.
#  RgB is the input/output RGB color set
#  HeX is the input/output hex color.

proc GUIconvColor { FmT RgB HeX {To32 0 } } {

   upvar $RgB cC
   upvar $HeX hC

   if $To32 { set hF "#%04x%04x%04x" } else { set hF "#%02x%02x%02x" }
   if [string match HEX $FmT] {
      if { ([string length $hC ] == 7) } {
         scan $hC "#%02x%02x%02x" cC(0) cC(1) cC(2)
	 if $To32 {
            set cC(0) [expr 256 * $cC(0) + $cC(0)]
            set cC(1) [expr 256 * $cC(1) + $cC(1)]
            set cC(2) [expr 256 * $cC(2) + $cC(2)]
         }
      } else { 
         scan $hC $hF cC(0) cC(1) cC(2)
	 if !$To32 {
            set cC(0) [expr $cC(0) >> 8]
            set cC(1) [expr $cC(1) >> 8]
            set cC(2) [expr $cC(2) >> 8]
	 }
      }
   }

   set hC [format $hF $cC(0) $cC(1) $cC(2)]
}
