package provide TclGUI 1.0

proc GUICanvas { W X Y Xs Ys { ShowSlider NO } } {
   global DevInfo Prefs GphInfo 

# MAKE initial checks that the scroll region is not smaller than the plot
#    region

   if { $Xs < $X } { set Xs $X }
   if { $Ys < $Y } { set Ys $Y }

   set pAr $W
   set sCr $W.drw
   if { ($X != $Xs) || ($Y != $Ys) || [string match YES $ShowSlider] } {
      canvas $sCr \
         -xscrollcommand [list $pAr.xscroll set] \
         -yscrollcommand [list $pAr.yscroll set] \
         -highlightthickness 0 -borderwidth 0 \
         -height $Y -width $X -background black -scrollregion "0 0 $Xs $Ys"
      scrollbar $pAr.xscroll -orient horizontal -command [list $sCr xview]
      scrollbar $pAr.yscroll -orient vertical -command [list $sCr yview]
      grid $sCr $pAr.yscroll -sticky news
      grid $pAr.xscroll -sticky ew
      grid rowconfigure $pAr 0 -weight 1
      grid columnconfigure $pAr 0 -weight 1
   } else {
      pack [ canvas $sCr -highlightthickness 0 \
             -borderwidth 0 -height $Y -width $X -background black ]
   }

   $sCr config -cursor crosshair
}
