package provide TclGPH 1.0

proc VtkSymBol { Just SyM } {
   global WinInfo GphInfo XYZ DevCt DevInfo 

# THIS is the current window

   set wN $GphInfo(curWin)

   if [info exist GphInfo(VtkSym)] {
      incr GphInfo(VtkSym)
   } else { set GphInfo(VtkSym) 0 }
   set iD $GphInfo(VtkSym)

   if { $WinInfo($wN,Clip) > 0 } {
      if { [GPHlineClip 0] == 0 } { return }
      set X [expr $XYZ(0)]
      set Y [expr $XYZ(1)]
   } else {
      set X [expr $XYZ(0) * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
      set Y [expr $XYZ(1) * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
   }

   if { $WinInfo($wN,Dimen) == 3 } {
      set Z [expr $XYZ(2) * $WinInfo($wN,s2) + $WinInfo($wN,i2)] 
   } else { set Z 0.0 }

   set tX [font measure "Courier $GphInfo(tSize)" 5]

# GET the color components

   set R [lindex $DevCt($GphInfo(tColor)) 0]
   set G [lindex $DevCt($GphInfo(tColor)) 1]
   set B [lindex $DevCt($GphInfo(tColor)) 2]

   if { ($WinInfo($wN,Dimen) == 3) && [string match UP $GphInfo(3Dz)] } {
      set TmP $X 
      set X $Y 
      set Y $Z 
      set Z $TmP 
   }

   switch -exact -- $SyM {
       square -
       fsquare {
          set D [expr 0.65 * $tX]
          vtkCubeSource SymBol$iD
             SymBol$iD SetXLength $D
             SymBol$iD SetYLength $D
             SymBol$iD SetZLength $D
             SymBol$iD SetCenter $X $Y $Z
       }
       default -
       circle -
       fcircle {
          set D [expr 0.65 * $tX / 2.0]
          vtkSphereSource SymBol$iD
             SymBol$iD SetRadius $D
             SymBol$iD SetCenter $X $Y $Z
       }
   }

   vtkPolyDataMapper SymMapper$iD
      SymMapper$iD SetInputConnection [SymBol$iD GetOutputPort]
   vtkActor SymActor$iD
      SymActor$iD SetMapper SymMapper$iD
      [SymActor$iD GetProperty] SetColor $R $G $B

# ADD to the render

   GPHRender AddActor SymActor$iD
}
