package provide TclGPH 1.0

proc VtkPoly { } {
   global WinInfo GphInfo XYZ XYZn GPHRender DevCt 

   set wN $GphInfo(curWin)
   if [info exist GphInfo(VtkLine)] { 
      incr GphInfo(VtkLine) 
   } else { set GphInfo(VtkLine) 0 }
   set iD $GphInfo(VtkLine)

   if { $XYZn < 3 } { return }

   if { $WinInfo($wN,Dimen) == 2 } { 
      set J 0
      if { $WinInfo($wN,Clip) == 0 } {
         set Sx $WinInfo($wN,s0) ; set Ix $WinInfo($wN,i0) 
         set Sy $WinInfo($wN,s1) ; set Iy $WinInfo($wN,i1) 
         for { set I 0 } { $I < $XYZn } { incr I } {
            set XYZ($J) [expr $XYZ($J) * $Sx + $Ix] ; incr J
            set XYZ($J) [expr $XYZ($J) * $Sy + $Iy] ; incr J
         }
      } else {
         GPHlineClip 1
         for { set I 1 } { $I < $XYZn } { incr I } {
            set XYZ($J) [expr int(floor($XYZ($J) + .5))] ; incr J
            set XYZ($J) [expr int(floor($XYZ($J) + .5))] ; incr J
         }
      }

# NOW set up the points

      vtkPoints PolyPoints$iD
         PolyPoints$iD SetNumberOfPoints $XYZn
         set I 0
         set J 1
         for { set K 0 } { $K < $XYZn } { incr K ; incr I 2 ; incr J 2 } {
            PolyPoints$iD InsertPoint $K $XYZ($I) $XYZ($J) 0
         }
   } else {
      set Sx $WinInfo($wN,s0) ; set Ix $WinInfo($wN,i0) 
      set Sy $WinInfo($wN,s1) ; set Iy $WinInfo($wN,i1) 
      set Sz $WinInfo($wN,s2) ; set Iz $WinInfo($wN,i2) 

      set J 0
      if { $WinInfo($wN,Clip) == 0 } {
         for { set I 0 } { $I < $XYZn } { incr I } {
            set XYZ($J) [expr $XYZ($J) * $Sx + $Ix] ; incr J
            set XYZ($J) [expr $XYZ($J) * $Sy + $Iy] ; incr J
            set XYZ($J) [expr $XYZ($J) * $Sz + $Iz] ; incr J
         }
      } else {
         GPHlineClip 1
         for { set I 1 } { $I < $XYZn } { incr I } {
            set XYZ($J) [expr int(floor($XYZ($J) + .5))] ; incr J
            set XYZ($J) [expr int(floor($XYZ($J) + .5))] ; incr J
            set XYZ($J) [expr int(floor($XYZ($J) + .5))] ; incr J
         }
      }

# NOW set up the points

      vtkPoints PolyPoints$iD
         PolyPoints$iD SetNumberOfPoints $XYZn
	  if [string match OUT $GphInfo(3Dz)] {
	     set I 0 ; set J 1 ; set L 2
         } else { set I 1 ; set J 2 ; set L 0 }
         for { set K 0 } { $K < $XYZn } { incr K ; incr I 3 ; incr J 3 } {
            PolyPoints$iD InsertPoint $K $XYZ($I) $XYZ($J) $XYZ($L)
	    incr L 3
         }
   }

# CONNECT the dots

    vtkPolygon PolySegs$iD
       [PolySegs$iD GetPointIds] SetNumberOfIds $XYZn
       for { set I 0 } { $I < $XYZn } { incr I } {
           [PolySegs$iD GetPointIds] SetId $I $I
       }

# CREATE the grid

    vtkUnstructuredGrid PolyGrid$iD
       PolyGrid$iD Allocate 1 1
       PolyGrid$iD InsertNextCell [PolySegs$iD GetCellType] \
                                  [PolySegs$iD GetPointIds]
       PolyGrid$iD SetPoints PolyPoints$iD

# MAP the polygon

    vtkDataSetMapper PolyMapper$iD
      PolyMapper$iD SetInput PolyGrid$iD

# GET the color components
   
    VtkFormColor $GphInfo(fColor) RGB

# SET up the polygon actor 

    vtkActor PolyActor$iD
      PolyActor$iD SetMapper PolyMapper$iD
      [PolyActor$iD GetProperty] SetDiffuseColor $RGB(0) $RGB(1) $RGB(2)
                                                                                
# ADD the render
    
    GPHRender AddActor PolyActor$iD
}
