package provide TclGPH 1.0

proc SetCorSys { CoSyS { CoSySoPs ""} } {
   global GphInfo

   set GphInfo(CoSyS) $CoSyS
   if { [string length $CoSySoPs] > 0 } {
      set GphInfo(CsOps) $CoSySoPs
   } else {
      set LatOffset 0.0
      set LngOffset 0.0
      set Radius 0.2

      switch -exact -- $CoSyS {
         BEHRMANN_CYLINDRICAL { set LatOffset 30.0 }
         TRISTAN_EDWARDS { set LatOffset 37.383 }
         PETERS { set LatOffset 44.138 }
         GALL_ORTHOGRAPHIC { set LatOffset 45.0 }
         BALTHASART { set LatOffset 50.0 }
         EQUIRECTANGULAR { set LatOffset 0.0 }
         MILLER37 { set LatOffset 37.5 }
         MILLER43 { set LatOffset 43.0 }
         MILLER50 { set LatOffset 50.4666666 }
      }

      set GphInfo(CsOps) [list $LngOffset $LatOffset $Radius]
   }
}
