package provide TclGPH 1.0

proc MapLine { wN X Y x y { nP 0 } { Tag "" } } {
   global WinInfo GphInfo 

   incr nP 1
   if { $X == $x } {
      set dY [expr ($y - $Y) / double($nP) ]
      for { set I 0 } { $I <= $nP } { incr I } {
         set Xm($I) $X
         set Ym($I) [expr $Y + $I * $dY]
      }
   } elseif { $Y == $y } {
      set dX [expr ($x - $X) / double($nP) ]
      for { set I 0 } { $I <= $nP } { incr I } {
         set Xm($I) [expr $X + $I * $dX]
         set Ym($I) $Y
      }
   } else {
      set Slope [expr ($x - $X)/($y - $Y)]
      if { $Slope > 1.0 } {
         set Intercept [expr $x - $Slope * $y]
         set dX [expr ($x - $X) / double($nP) ]
         for { set I 0 } { $I <= $nP } { incr I } {
            set Xm($I) [expr $X + $I * $dX]
            set Ym($I) [expr ($Xm($I) - $Intercept) / $Slope]
         }
      } else {
         set Slope [expr ($y - $Y)/($x - $X)]
         set Intercept [expr $y - $Slope * $x]
         set dY [expr ($y - $Y) / double($nP) ]
         for { set I 0 } { $I <= $nP } { incr I } {
            set Ym($I) [expr $Y + $I * $dY]
            set Xm($I) [expr ($Ym($I) - $Intercept) / $Slope]
         }
      }
   }

   incr nP
   Lines $wN Xm Ym Xm $nP 0 $Tag
}
