package provide TclGPH 1.0

proc GraphicsOn { Device cTable { revBW NOSWAP } { CaNVaS NONE } { cS 0 } } {
   global GphProcs GphInfo DevInfo WinInfo DevCt

   GPHinits GPHSETS

   set DevInfo(Dev) $Device
   set GphInfo(ToRad)  [expr acos(-1.0) / 180.0 ]

   if [string match SWAP $revBW] { 
      set GphInfo(revBC) 1 
   } else { set GphInfo(revBC) 0 }

   switch -exact -- $Device {
      TK   {   
         set GphProcs(ON) TkInit
         set GphProcs(SymBol) { TkSymBol $Just $Sym }
         set GphProcs(CTable) { TkLoadColors $cFile }
         set GphProcs(Line) TkLine
         set GphProcs(Poly) TkPoly
         set GphProcs(BColor) TkBkgColor
         set GphProcs(Text) { TkText $Just $Text $Ang }
         if  ![string match OMIT $cS ] { 
             TkInit $CaNVaS 
             set GphInfo(CurScr) $cS
         }
      }
      VTK  {   
         if ![info exists GphInfo(vtkSFac)] { set GphInfo(vtkSFac) 0.5 }
         set GphProcs(ON) VTkInit
         set GphProcs(CTable) {VtkLoadColors $cFile }
         set GphProcs(SymBol) { VtkSymBol $Just $Sym }
         set GphProcs(Line) VtkLine
         set GphProcs(Poly) VtkPoly
         set GphProcs(Text) { VtkText $Just $Text $Ang }
         set GphProcs(BColor) VtkBkgColor
         set GphInfo(CurScr) $cS
         package require vtk
         package require vtkinteraction
         VtkInit

#        wm withdraw .
      }
   }

   if { [LoadColorTable $cTable] < 0 } { return -1 }
   if ![string match OMIT $cS ] { 
      set wN bW$cS
      GenWindow $wN 0. 0. 0. 1.0 1.0 1.0 0. 0. 0. 1. 1. 0.
      BackGround HOLD
   }
   PlotColor HOLD $GphInfo(lColor) OFF
 
   return 1
}
