package provide TclGPH 1.0

#
# THIS function draws a rasterized filled polygon in the current GIF screen.
#    Only works for rectangles.  If is the responsibility of the invoking
#    routine to check this and also to check that the current screen is a 
#    GIF screen.  Hard to imagine you could get in here if it weren't.
#
# NOTE: All variable inputs are integers
#

proc GPHpolyRaster { Xa Ya Xb Yb } {
   global DevInfo GphInfo 

   set sC GIF$GphInfo(CurScr)

   upvar $DevInfo($sC) C
   upvar $Coor XY

   set Color $GphInfo(fColor)
   set vX [expr $DevInfo($sC.Width) + 1]
   set vY [expr $DevInfo($sC.Height) + 1]
   set MaxLen [expr int($vX * $vY)]

   set Y $Ya
   while { $Y <= $Yb } {
      set Pos [expr int($X + $Width * $Y)]
      set X $Xa
      while { $X <= $Xb } {
         if { $Pos < $MaxLen } { set C($Pos)  $Color }
         incr Pos
         incr X
      }
   }
}
