package provide TclGPH 1.0

#
# THIS function draws a rasterized line in the current GIF screen.  The 
#    line is drawn using the Bresenham algorithm.  The invoking procedure 
#    is responsible for checking that the current screen is a GIF screen.
#    Hard to imagine you could get in here if it weren't.
#
# NOTE: All variable inputs are integers
#

proc GPHlineRaster { Coors N Src } {
   global DevInfo GphInfo 

   set sC GIF$GphInfo(CurScr)

   upvar $DevInfo($sC) C
   upvar $Coor XY

   if { Src == 0 } {
      set Color $GphInfo(lColor)
   } else {
      set Color $GphInfo(fColor)
   }

   set vX [expr $DevInfo($sC.Width) + 1]
   set vY [expr $DevInfo($sC.Height) + 1]
   set MaxLen [expr int($vX * $vY)]

   set I 0
   set Xa $XY($I) ; incr I
   set Ya $XY($I) ; incr I
   for { set J 1 } { $J < $N } { incr J } {
      set Xb $XY($I) ; incr I
      set Yb $XY($I) ; incr I
      set dX [expr int( abs($Xa - $Xb) )]
      set dY [expr int( abs($Ya - $Yb) )]
      if { $GphInfo(oStyle) == 0 } { set Width $vX } else { set Width $vY }

# HERE the algorithm switches so that one branch is used for lines which
#    are more horizontal than vertical and the other for the opposite.

      if { $dX < $dY } {
         if { $Xa > $Xb) } {
            set X $Xb;
            set Y $Yb;
            set End $Xa;
            if { $dY == 0 } { 
               set Inc 0
            } elseif { $Yb > $Ya } { set Inc -1 } else { set Inc 1 } 
         } else {
            set X $Xa;
            set Y $Ya;
            set End $Xb;
            if { $dY == 0 } { 
               set Inc 0
            } elseif { $Yb > $Ya } { set Inc 1 } else { set Inc -1 } 
         }

         set Inc1 [expr 2 * $dY]
         set dELTA [expr $Inc1 - $dX]
         set Inc2 [expr 2 * ($dY - $dX)]

         set Pos [expr int($X + $Width * $Y)]
         if { $Pos < $MaxLen } { set C($Pos)  $Color }

         while { $X <= $End } {
            if { $dELTA < 0 } {
               incr dELTA $Inc1;
            } else {
               incr Y $Inc;
               incr dELTA $Inc2;
            }
            incr X

            set Pos [expr int($X + $Width * $Y)]
            if { $Pos < $MaxLen } { set C($Pos)  $Color }
         }
      }  else {
         if { $Ya > $Yb) } {
            set X $Xb;
            set Y $Yb;
            set End $Ya;
            if { $dX == 0 } { 
               set Inc 0
            } elseif { $Xb > $Xa } { set Inc -1 } else { set Inc 1 } 
         } else {
            set X $Xa;
            set Y $Ya;
            set End $Yb;
            if { $dX == 0 } { 
               set Inc 0
            } elseif { $Xb > $Xa } { set Inc 1 } else { set Inc -1 } 
         }

         set Inc1 [expr 2 * $dX]
         set dELTA [expr $Inc1 - $dY]
         set Inc2 [expr 2 * ($dX - $dY)]

         set Pos [expr int($X + $Width * $Y)]
         if { $Pos < $MaxLen } { set C($Pos)  $Color }

         while { $Y <= $End } {
            if { $dELTA < 0 } {
               incr dELTA $Inc1;
            } else {
               incr X $Inc;
               incr dELTA $Inc2;
            }
            incr Y

            set Pos [expr int($X + $Width * $Y)]
            if { $Pos < $MaxLen } { set C($Pos)  $Color }
         }
      }
     
      set Xa $Xb
      set Ya $Yb
   }
}
