package provide TclGPH 1.0

proc GPHlineClip { Src } {
   global GphInfo XYZp XYZ XYZn WinInfo

#  NO data check

   set POLY 1
   if { $XYZn == 0 } { return 0 }
   if { ($Src == $POLY) && ($XYZn < 3) } { return 0 }

   set wN $GphInfo(curWin)

# SET skip for number of dimensions

   set dInc [expr $WinInfo($wN,Dimen) - 1] 

   set Cnt 0
   set Qcnt 0
   set LastPnt 0
   set CornerPlot 0

# GET the pixel locations of the X corners of the window

   set B(0) [lindex $WinInfo($wN,b) 0]
   set B(1) [lindex $WinInfo($wN,b) 1]
   set B(2) [lindex $WinInfo($wN,b) 2]
   set B(3) [lindex $WinInfo($wN,b) 3]

   if { $WinInfo($wN,Clip) == 2 } {
      set B(0) [expr $B(0) + 1 ]
      set B(1) [expr $B(1) + 1 ]
      set B(2) [expr $B(2) - 1 ]
      set B(3) [expr $B(3) - 1 ]
   }

# DO a mass conversion of the input data

   set J 0
   for { set I 0 } { $I < $XYZn } { incr I } { 
      set X($J) [expr $XYZ($J) * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
      incr J
      set X($J) [expr $XYZ($J) * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
      incr J $dInc
      set P($I) $XYZp($I)
   }


# FOR a POLY make sure the first and last points match

   if { $Src == $POLY } {
      set LastX [expr 2 * $XYZn - 2]
      set LastY [expr 2 * $XYZn - 1]
      if { ($X(0) != $X($LastX)) || ($X(1) != $X($LastY)) } {
         incr LastY
         set X($LastY) $X(0) ; incr LastY
         set X($LastY) $X(1) ; incr XYZn
         set P($I) 1
      }
   }

# SO the one point case were the one point is a move

   if { ($XYZn == 1) && ($P(0) == 0) } {
      if {($X(0) < $B(0)) || ($X(0) > $B(2)) || ($X(1) < $B(1)) || \
                                                ($X(1) > $B(3))} {
          return 0
      } 
      set XYZ(0) $X(0)
      set XYZ(1) $X(1)
      return (1);
   }

# BEGIN to process pairs of points, every point except the first and last 
#     are looked at as both the beginning and ending point in a line

   set I 0
   set J 0
   set K 0
   set L 0
   set End [expr $XYZn + $XYZn]
   while { $I < $End } {
      if { $P($L) == 1 } {
         set Pnt(0) $Pnt(2)
         set Pnt(1) $Pnt(3)
         set Pnt(2) $X($I) ; incr I
         set Pnt(3) $X($I) ; incr I
         set ReT [ GPHclipIt Pnt PntO Quad Qcnt B $Two ]
         set Action [lindex $ReT 0 ]
         set Q [lindex $ReT 1 ]
         set Two 0
      } else {
         set Pnt(2) $X($I) ; incr I
         set Pnt(3) $X($I) ; incr I
         incr L
         set EndOK 0
         set Two 1
         continue
      }

# IF this is the last point and we are drawing a filled polygon then if 
#    the last point is out make it appear to be in to be able to run 
#    through the corner check to see it a corner point needs to be added 
#    to the point array

      if {($Action < 0) && ($I >= $End) && ($Src == $POLY) } {       
         set EndOK 0
         set Action 0
         set LastPnt 1
      }                                                                

      if { $Action >= 0 } {
         if { $EndOK } {
            set XYZ($J) $PntO(2) ; incr J
            set XYZ($J) $PntO(3) ; incr J $dInc
            set XYZp($K) 1 ; incr K
            if { $Action > 1 } { set EndOK 0 } else { set EndOK 1 }
         } elseif { ( $Qcnt > 0) && ($Src == $POLY ) } {
            for { set M 0 } { $M < $Qcnt } { incr M } { 
               switch -exact -- $Quad($M) {
                  0 -
                  2 -
                  4 -
                  6    {  }
                  1    {  set XYZ($J) $B(0) ; incr J
                          set XYZ($J) $B(1) ; incr J $dInc
                          set XYZp($K) 1 ; incr K
                       }
                  3    {  set XYZ($J) $B(2) ; incr J
                          set XYZ($J) $B(1) ; incr J $dInc
                          set XYZp($K) 1 ; incr K
                       }
                  5    {  set XYZ($J) $B(2) ; incr J
                          set XYZ($J) $B(3) ; incr J $dInc
                          set XYZp($K) 1 ; incr K
                       }
                  7    {  set XYZ($J) $B(0) ; incr J
                          set XYZ($J) $B(3) ; incr J $dInc
                          set XYZp($K) 1 ; incr K
                       }
               }
               set Quad($M) -1
            }
            set Qcnt 0
            set CornerPlot 1
         } else { set Qcnt 0 }

         if { !$LastPnt } {
            set XYZ($J) $PntO(0) ; incr J
            set XYZ($J) $PntO(1) ; incr J $dInc
            set XYZ($J) $PntO(2) ; incr J
            set XYZ($J) $PntO(3) ; incr J $dInc

            if { $CornerPlot } {
               set XYZp($K) 1 ; incr K
               set CornerPlot 0
            } else { 
               set XYZp($K) 0 ; incr K
            }
            set XYZp($K) 1 ; incr K
            if { $Action > 1 } { set EndOK 0 } else { set EndOK 1 }
         }
      } else { set EndOK 0 }

      incr L
   }

   set XYZn $K
} 
