# THIS routine moves a selected item to a new position.  The item must
#    have been selected through a call to GPHitemMark.

package provide TclGPH 1.0

proc GPHitemMove { W x y } {
   global WinInfo GphInfo

# MAKE sure that there is an item to move.  Check variable exists and then
#   move item only if an item has been selected

   if ![info exists GphInfo($W,obj)] { return }

   if { $GphInfo($W,obj) >= 0 } {

# MAP the new item position to canvas coordinates

      set x [$W canvasx $x]
      set y [$W canvasy $y]

# THIS is how far to move the item

      set dx [expr $x - $GphInfo($W,x)]
      set dy [expr $y - $GphInfo($W,y)]

# MOVE the item

      $W move $GphInfo($W,obj) $dx $dy

# SAVE the current item position

      set GphInfo($W,x) $x
      set GphInfo($W,y) $y
   }
}
