package provide GMEPlot 1.0

# THIS puts the User Interface

proc UserInterface { } {
   global gmANS GphInfo env

# READ in the preference file
                                                                                
   GUIprefsRead

# LAY out the window names for the GUI frame structure
                                                                                
   set Wa  .gmeCTRL
   set Wb  .gmANS

   set ScOps [list LINEAR|0 LOG|1]
   set CbOps [list VERTICAL|0 RHORIZONTAL|1 LHORIZONTAL|2]
   set YNOps [list NO|0 YES|1]
   set FtOps [list "2 MAXWELLIANS (Linear)|0" \
                   "2 MAXWELLIANS (NLinear)|1" \
                   "KAPPA |2" ]
   set MoOps [list "FROM FIT|0" INTEGRATED|1]
   set MaOps [list SPLIT|0 FULL|1]
   set MbOps [list WIDTHS|0 CENTERS|1]
   set OmOps [list NONE|0 PLOTS|1 FITS|2 "PLOTS AND FITS|3"]
   set SrOps [list "WHITE BACKGROUND|SWAP" "BLACK BACKGROUND|NOWSWAP"]
   set FlOps [list "NO FILTER|0" 3x3L|1 5x5L|2 ]

   if { [winfo exists .gmeCTRL] == 0 } {
      wm title . "GME PLOTS"
                                                                                
      GUIFrame $Wa -1 pack|top||x
      GUIFrame $Wb -1 pack|top||x

      GUIbuttonPush $Wa.quit Quit pack|right "exit" 6
      GUIboxEntry $Wa.zm  pack|right 7 gmANS(Zoom)
      GUILabel $Wa.lxm "Zoom" c pack|right 
      GUIbuttonPush $Wa.run Run   pack|left   "RunIt" 6

      
      set CtOps [GUctblOpts]
      if ![info exists gmANS(CtBl)] {
         set gmANS(CtBl) [lindex [split [lindex $CtOps 0] '|'] 1 ]
         set CtLab [lindex [split [lindex $CtOps 0] '|'] 0 ]
      } else {
         set CtLab ""
         set nCt [llength $CtOps]
         for { set I 0 } { $I < $nCt } { incr I } {
            set AlT [lindex [split [lindex $CtOps $I] '|'] 1 ]
            if {[string compare $AlT $gmANS(CtBl)] == 0 } {
               set CtLab [lindex [split [lindex $CtOps $I] '|'] 0 ]
               break
            }
         }
         
         if { [string length $CtLab] == 0 } {
            set gmANS(CtBl) [lindex [split [lindex $CtOps 0] '|'] 1 ]
            set CtLab [lindex [split [lindex $CtOps 0] '|'] 0 ]
         } 
      }

      set Row 0

      GUILabel $Wb.rdlab "Read Menu"  w grid|$Row|0|w
      GUIboxEntry $Wb.read  grid|$Row|1|w||3 19 gmANS(OptFile)
      GUIbuttonPush $Wb.readb Read grid|$Row|4|w| "RetrieveOpts 1" 6

      incr Row 
      GUILabel $Wb.svlab "Save Menu"  w grid|$Row|0|w
      GUIboxEntry $Wb.save  grid|$Row|1|w||3 19 gmANS(saveM)
      GUIbuttonPush $Wb.saveb Save grid|$Row|4|w| "SaveOpts" 6

      incr Row 
      GUILabel $Wb.ctlab "Color Scheme"  w grid|$Row|0|w
      GUIbuttonMenu $Wb.ct $CtLab grid|$Row|1|ew||3 $CtOps  \
           "GUIoptsProcess .gmANS.ct gmANS(CtBl) ALT " 6
      if [string match SWAP $gmANS(ScrBgnd)] {
         set LaB "WHITE BACKGROUND"
      } else { set LaB "BLACK BACKGROUND" }
      GUIbuttonToggle $Wb.scrc $LaB grid|$Row|4|e||3 \
              $SrOps "GUIoptsToggle $Wb.scrc gmANS(ScrBgnd) ALT " 6

      incr Row 
      GUILabel $Wb.hctlab "He+ Color Scale"  w grid|$Row|0|w
      GUIboxEntry $Wb.hmin  grid|$Row|1|||2 8 gmANS(cBHMin)
      GUIboxEntry $Wb.hmax  grid|$Row|3 8 gmANS(cBHMax)
      GUIbuttonToggle $Wb.hsca $gmANS(cBHSca) grid|$Row|4|ew \
              $ScOps "GUIoptsToggle $Wb.hsca gmANS(cBHSca) PRI " 6

      incr Row 
      GUILabel $Wb.ictlab "Ion Color Scale"  w grid|$Row|0|w
      GUIboxEntry $Wb.imin  grid|$Row|1|||2 8 gmANS(cBIMin)
      GUIboxEntry $Wb.imax  grid|$Row|3 8 gmANS(cBIMax)
      GUIbuttonToggle $Wb.isca $gmANS(cBISca) grid|$Row|4|ew \
              $ScOps "GUIoptsToggle $Wb.isca gmANS(cBISca) PRI " 6

      incr Row 
      GUILabel $Wb.idtlab "Ion Den Color Scale"  w grid|$Row|0|w
      GUIboxEntry $Wb.idmin  grid|$Row|1|||2 8 gmANS(cBIDMin)
      GUIboxEntry $Wb.idmax  grid|$Row|3 8 gmANS(cBIDMax)
      GUIbuttonToggle $Wb.idsca $gmANS(cBIDSca) grid|$Row|4|ew \
              $ScOps "GUIoptsToggle $Wb.idsca gmANS(cBIDSca) PRI " 6

      incr Row 
      GUILabel $Wb.ittlab "Ion Temp Color Scale"  w grid|$Row|0|w
      GUIboxEntry $Wb.itmin  grid|$Row|1|||2 8 gmANS(cBITMin)
      GUIboxEntry $Wb.itmax  grid|$Row|3 8 gmANS(cBITMax)
      GUIbuttonToggle $Wb.itsca $gmANS(cBITSca) grid|$Row|4|ew \
              $ScOps "GUIoptsToggle $Wb.itsca gmANS(cBITSca) PRI " 6

      incr Row 
      GUILabel $Wb.rttlab "Ion Ratio Color Scale"  w grid|$Row|0|w
      GUIboxEntry $Wb.rtmin  grid|$Row|1|||2 8 gmANS(cBIRMin)
      GUIboxEntry $Wb.rtmax  grid|$Row|3 8 gmANS(cBIRMax)
      GUIbuttonToggle $Wb.rtsca $gmANS(cBITSca) grid|$Row|4|ew \
              $ScOps "GUIoptsToggle $Wb.rtsca gmANS(cBIRSca) PRI " 6

      incr Row 
      GUILabel $Wb.cblab "ColorBar Placement"  w grid|$Row|0|w
      GUIbuttonMenu $Wb.pla $gmANS(cbDir) grid|$Row|1|||3 $CbOps  \
           "GUIoptsProcess $Wb.pla gmANS(cbDir) PRI " 6

      incr Row 
      GUILabel $Wb.dmsplab "Add Lineplots"  w grid|$Row|0|w
      GUIbuttonToggle $Wb.dmsp $gmANS(DmSp) grid|$Row|1|ew||2 \
              $YNOps "DMSPGui $Wb.dmsp " 6

      incr Row 
      GUILabel $Wb.scatlab "Add XY Plots"  w grid|$Row|0|w
      GUIbuttonToggle $Wb.scat $gmANS(XYplot) grid|$Row|1|ew||2 \
              $YNOps "XYGui $Wb.scat " 6

      incr Row 
      GUILabel $Wb.pxylab "Map Plot Length"  w grid|$Row|0|w
      GUIboxEntry $Wb.pxy  grid|$Row|1|||2 8 gmANS(pLen)

      incr Row 
      GUILabel $Wb.ilowlab "Ion Inv CutOff"  w grid|$Row|0|w
      GUIboxEntry $Wb.ilow  grid|$Row|1|||2 8 gmANS(ionLow)

      incr Row 
      GUILabel $Wb.ehlab "EUV Inv Dir"  w grid|$Row|0|w
      GUIboxEntry $Wb.ehome  grid|$Row|1|w||4 25 gmANS(EUVHOME)

      incr Row 
      GUILabel $Wb.mhlab "MENA Inv Dir"  w grid|$Row|0|w
      GUIboxEntry $Wb.mhome  grid|$Row|1|w||4 25 gmANS(MENAHOME)

      incr Row 
      GUILabel $Wb.hhlab "HENA Inv Dir"  w grid|$Row|0|w
      GUIboxEntry $Wb.hhome  grid|$Row|1|w||4 25 gmANS(HENAHOME)

      incr Row 
      GUILabel $Wb.euvlab "EUV Base File"  w grid|$Row|0|w
      GUIboxEntry $Wb.euv  grid|$Row|1|w||4 25 gmANS(EUVFILE)
      set LaB [lindex [split [lindex $FlOps $gmANS(psFilter)] "|"] 0]
      GUIbuttonMenu $Wb.flt $LaB grid|$Row|5|w||2 $FlOps \
           "GUIoptsProcess $Wb.flt gmANS(psFilter) ALT " 6 -1 "" left

      incr Row 
      GUILabel $Wb.menalab "MENA Base File"  w grid|$Row|0|w
      GUIboxEntry $Wb.mena  grid|$Row|1|w||4 25 gmANS(MENAFILE)

      incr Row 
      GUILabel $Wb.henalab "HENA Base File"  w grid|$Row|0|w
      GUIboxEntry $Wb.hena  grid|$Row|1|w||4 25 gmANS(HENAFILE)

      incr Row 
      GUILabel $Wb.shftlab "Show Fits"  w grid|$Row|0|w
      GUIbuttonToggle $Wb.shft $gmANS(showFIT) grid|$Row|1|ew||2 \
              $YNOps "GUIoptsToggle $Wb.shft gmANS(showFIT) PRI " 6

      incr Row 
      GUILabel $Wb.ftlab "Fit Algorithm"  w grid|$Row|0|w
      set LaB [lindex [split [lindex $FtOps $gmANS(fitID)] "|"] 0]
      GUIbuttonMenu $Wb.fit $LaB grid|$Row|1|w||4 $FtOps \
           "GUIoptsProcess $Wb.fit gmANS(fitID) ALT " 6 -1 "" left

      incr Row 
      GUILabel $Wb.momlab "Moment Info" w grid|$Row|0|w
      set LaB [lindex [split [lindex $MoOps $gmANS(momID)] "|"] 0]
      GUIbuttonToggle $Wb.mom $LaB grid|$Row|1|ew||3 \
              $MoOps "GUIoptsToggle $Wb.mom gmANS(momID) ALT " 6
      GUIbuttonToggle $Wb.mrng $gmANS(momRNG) grid|$Row|4|ew \
              $MaOps "GUIoptsToggle $Wb.mrng gmANS(momRNG) PRI " 6
      GUIbuttonToggle $Wb.mty $gmANS(momTYPE) grid|$Row|5|ew \
              $MbOps "GUIoptsToggle $Wb.mty gmANS(momTYPE) PRI " 6

      incr Row 
      GUILabel $Wb.omslab "Data Omissions"  w grid|$Row|0|w
      set LaB [lindex [split [lindex $OmOps $gmANS(MHomits)] "|"] 0]
      GUIbuttonMenu $Wb.oms $LaB grid|$Row|1|||3 $OmOps \
           "GUIoptsProcess $Wb.oms gmANS(MHomits) ALT " 6

      incr Row 
      GUILabel $Wb.molab "MENA Omits"  w grid|$Row|0|w
      GUIboxEntry $Wb.mo  grid|$Row|1|w||3 15 gmANS(MENAomits)

      incr Row 
      GUILabel $Wb.holab "HENA Omits"  w grid|$Row|0|w
      GUIboxEntry $Wb.ho  grid|$Row|1|w||3 15 gmANS(HENAomits)

      incr Row 
      GUILabel $Wb.rclab "Plot Matrix (RxC)"  w grid|$Row|0|w
      GUIboxEntry $Wb.row  grid|$Row|1|w 4 gmANS(nR)
      GUIboxEntry $Wb.col  grid|$Row|2|w 4 gmANS(nC)

      incr Row 
      GUIblankRow $Wb $Row 1.0
      
      incr Row 
      GUILabel $Wb.pdlab "Plot Definitions"  w grid|$Row|0|w

      incr Row 
      set gmANS(pGridRow) $Row
      for { set I 0 } { $I < $gmANS(nR) } { incr I } {
         GUILabel $Wb.r${I}lab "Row $I"  w grid|$Row|0|w
         set Col 1
         for { set J 0 } { $J < $gmANS(nC) } { incr J } {
            set DeF r${I}c${J}
            if { $J == 0 } {
               GUIboxEntry $Wb.$DeF grid|$Row|$Col|||2 8 gmANS($DeF)
               incr Col 2
            } else {
               GUIboxEntry $Wb.$DeF grid|$Row|$Col 8 gmANS($DeF)
               incr Col 1
            }
         }
         incr Row 
      }
   }

   if [string match YES $gmANS(DmSp)]   { DMSPGui "" }
   if [string match YES $gmANS(XYplot)] { XYGui ""   }

   update
   bind  .gmANS.read <Return> { .gmANS.save delete 0 end ; \
                                  .gmANS.save insert end "$gmANS(OptFile)"}
   bind  .gmANS.row <Return>  {  ChgGUIpGrid }
   bind  .gmANS.col <Return>  {  ChgGUIpGrid }
}
