package provide GMEPlot 1.0

# THIS makes a slew of pre-run/post-menu decisions

proc SetUp { } {

   global gmANS env

   if [winfo exists .sWin10] { destroy .sWin10 }
   if [winfo exists .pLoT0] { 
       destroy .pLoT0  
       set GphInfo(CurScr) 0
   }
   if [info exists WinInfo(50,Dimen)] { CloseWindow 50 }

# EXPAND the requested time by 10 minutes on either end.

   set gmANS(sY) $gmANS(bYr) ; set gmANS(sD) $gmANS(bDy) 
   set gmANS(sH) $gmANS(bHr) ; set gmANS(sM) [expr $gmANS(bMn) - 10] 
   set gmANS(sS) $gmANS(bSc)
   set gmANS(fY) $gmANS(eYr) ; set gmANS(fD) $gmANS(eDy) 
   set gmANS(fH) $gmANS(eHr) ; set gmANS(fM) [expr $gmANS(eMn) + 10] 
   set gmANS(fS) $gmANS(eSc)

   if { $gmANS(sM) < 0 } {
      incr gmANS(sM) 60 ; incr gmANS(sH) -1
      if { $gmANS(sH) < 0 } { incr gmANS(sH) 24 ; incr gmANS(sD) -1 }
      if { $gmANS(sD) < 1 } {
         incr gmANS(sY) -1
         incr gmANS(sD) [TUyearLeap $gmANS(sY)]
       }
   }
   if { $gmANS(fM) > 59 } {
      incr gmANS(fM) -60 ; incr gmANS(fH)
      if { $gmANS(fH) > 23 } { incr gmANS(fH) -24 ; incr gmANS(fD) }
      set DiY [TUyearLeap $gmANS(fY)]
      if { $gmANS(fD) > $DiY } {
          incr gmANS(fY)
          incr gmANS(fD) -$DiY
      }
   }

# Beginning and ending Ms 

   set gmANS(bMs) [expr ($gmANS(bHr) * 3600 + $gmANS(bMn) * 60 \
                                         + $gmANS(bSc)) * 1000]
   set gmANS(eMs) [expr ($gmANS(eHr) * 3600 + $gmANS(eMn) * 60 \
                                         + $gmANS(eSc)) * 1000]
   set gmANS(sMs) [expr ($gmANS(sH) * 3600 + $gmANS(sM) * 60 \
                                         + $gmANS(sS)) * 1000]
   set gmANS(fMs) [expr ($gmANS(fH) * 3600 + $gmANS(fM) * 60 \
                                         + $gmANS(fS)) * 1000]

# BASE time to use in offset computations.

   set gmANS(baseT) [list $gmANS(bYr) $gmANS(bDy) $gmANS(bMs) 0]
   set gmANS(sP) 0
   set tM [list $gmANS(eYr) $gmANS(eDy) $gmANS(eMs) 0]
   set gmANS(eP) [TUtimeConv $gmANS(baseT) $tM 0 gmANS(Base)]

# BASE time to use in offset computations.
   
   if { $gmANS(pLen) < 0.0 } {
      set gmANS(pMin) [expr  $gmANS(pLen)]
      set gmANS(pMax) [expr -$gmANS(pLen)]
      set gmANS(gMin) [expr -$gmANS(pLen)]
      set gmANS(gMax) [expr  $gmANS(pLen)]
   } else {
      set gmANS(pMin) [expr  $gmANS(pLen)]
      set gmANS(pMax) [expr -$gmANS(pLen)]
      set gmANS(gMin) [expr  $gmANS(pLen)]
      set gmANS(gMax) [expr -$gmANS(pLen)]
   }

# THESE variables indicate whether we need to load or create a set of 
#    mapping data or SSIES data

   set gmANS(LoadE)   0
   set gmANS(LoadH)   0
   set gmANS(LoadM)   0
   set gmANS(LoadPF)  0
   set gmANS(LoadPS)  0
   set gmANS(LoadRF)  0
   set gmANS(LoadRM)  0
   set gmANS(LoadRH)  0
   set gmANS(LoadSS)  0

# THESE variables indicate whether we need to put up a colorbar for a
#   particular range definition

   set gmANS(CBarE)   0
   set gmANS(CBarI)   0
   set gmANS(CBarR)   0
   set gmANS(CBarT)   0
   set gmANS(CBarD)   0

# LOOP over the map plots

   for { set I 0 } { $I < $gmANS(nR) } { incr I } {
      for { set J 0 } { $J < $gmANS(nC) } { incr J } {
         set DeF r${I}c${J}
         switch -glob -- $gmANS($DeF) {
            EUV   { set gmANS(LoadE) 1 ;  set gmANS(CBarE) 1 } 
            MENA* { set gmANS(LoadM) 1 ;  set gmANS(CBarI) 1 } 
            HENA* { set gmANS(LoadH) 1 ;  set gmANS(CBarI) 1 } 
            MOM*  { 
	       set gmANS(LoadH) 1 ; set gmANS(LoadM) 1
               set S [string index $gmANS($DeF) 3]
               set P [string index $gmANS($DeF) 4]
               if { $S == "F" } { 
                  set gmANS(LoadPF) 1
               } else { set gmANS(LoadPS) 1 }
               if { $P == "T" } { set gmANS(CBarT) 1 }
               if { $P == "D" } { set gmANS(CBarD) 1 }
            } 
            RATIO*  { 
               set gmANS(CBarR) 1
	       set gmANS(LoadE) 1
	       set gmANS(LoadH) 1 ; set gmANS(LoadM) 1 
               set S [string index $gmANS($DeF) 5]
               if { $S == "F" } { 
                  set gmANS(LoadPF) 1
                  set gmANS(LoadRF) 1
               } else { set gmANS(LoadPS) 1 }
               if { $S == "H" } { set gmANS(LoadRH) 1 }
               if { $S == "M" } { set gmANS(LoadRM) 1 }
            } 
         }
      }
   }

# DETERMINE how many colorbars we will need to put up.

   set cList [list E I R T D]
   set gmANS(nCB)     0
   for { set I 0 } { $I < 5 } { incr I } {
      if { $gmANS(CBar[lindex $cList $I]) > 0 } { incr gmANS(nCB) }
   }

# LOOK through the lineplot definitions if there are any

   set gmANS(TotalLP) 0
   for { set I 0 } { $I < $gmANS(nLP) } { incr I } {
      set gmANS(LP${I}Q) 0
      for { set J 0 } { $J < 2 } { incr J } {
         set iD Q$I$J
         if { $gmANS($iD) > 0 }   { incr gmANS(LP${I}Q) }
      }
      if { $gmANS(LP${I}Q) > 0 } { incr gmANS(TotalLP) }
   }

# LOOK through the XY plot definitions if there are any

   set gmANS(TotalXY) 0
   for { set I 0 } { $I < $gmANS(nXY) } { incr I } {
      set dAxis 0
      for { set J 0 } { $J < 2 } { incr J } {
         set iD S$I$J
         if { $gmANS($iD) > 0 }   { incr dAxis }
      }
      if { $dAxis == 2 } { incr gmANS(TotalXY) }
   }

# DO we need any SSIES data

   set pDef [PlotCheck 80 92]
   set nP [llength $pDef]
   if { $nP > 0 } { set gmANS(LoadSS) 1 }

# CHECK for data that needs to be loaded and maps built to satisfy some
#   of the lineplots.  Start with moment lineplots

   set pDef [PlotCheck 60 69]
   set nP [llength $pDef]
   if { $nP > 0 } { set gmANS(LoadH) 1 ; set gmANS(LoadM) 1 }
   for { set I 0 } { $I < $nP } { incr I } {
      set tP [split [lindex $pDef $I] "|"]
      set Q  [lindex $tP 2]
      if { $Q < 62 } {
          set gmANS(LoadPF) 1
      } else { set gmANS(LoadPLoadPS) 1 }
   }

# NOW look at the ratio plots

   set pDef [PlotCheck 100 102]
   set nP [llength $pDef]
   if { $nP > 0 } { 
      set gmANS(LoadE) 1 
      set gmANS(LoadH) 1 ; set gmANS(LoadM) 1 
   }
   for { set I 0 } { $I < $nP } { incr I } {
      set tP [split [lindex $pDef $I] "|"]
      set Q  [lindex $tP 2]
      if { $Q == 100 } { set gmANS(LoadRH) 1 ; set gmANS(LoadPS) 1 }
      if { $Q == 101 } { set gmANS(LoadRM) 1 ; set gmANS(LoadPS) 1 }
      if { $Q == 102 } { set gmANS(LoadRF) 1 ; set gmANS(LoadPF) 1 }
   }

# SEE if there is any EUV data out there

   if { [string length $gmANS(EUVHOME)] > 0  } {
      set PatH [file split $gmANS(EUVHOME)] 
      set Home [lindex $PatH 0]
      if { [string index $Home 0] == "$" } {
         set fN $env([string trim $Home "$"])
      } else { set fN [lindex $PatH 0] }
      set nE [llength $PatH]
      for { set I 1 } { $I < $nE } { incr I } {
         set fN [file join $fN [lindex $PatH $I]]
      }
      set gmANS(EUVHOME) $fN
   } else { set gmANS(LoadE) 0 } 

# SEE if there is any MENA data out there

   if { [string length $gmANS(MENAHOME)] > 0  } {
      set PatH [file split $gmANS(MENAHOME)] 
      set Home [lindex $PatH 0]
      if { [string index $Home 0] == "$" } {
         set fN $env([string trim $Home "$"])
      } else { set fN [lindex $PatH 0] }
      set nE [llength $PatH]
      for { set I 1 } { $I < $nE } { incr I } {
         set fN [file join $fN [lindex $PatH $I]]
      }
      set gmANS(MENAHOME) $fN
   } else { set gmANS(LoadM) 0 } 

# SEE if there is any HENA data out there

   if { [string length $gmANS(HENAHOME)] > 0  } {
      set PatH [file split $gmANS(HENAHOME)] 
      set Home [lindex $PatH 0]
      if { [string index $Home 0] == "$" } {
         set fN $env([string trim $Home "$"])
      } else { set fN [lindex $PatH 0] }
      set nE [llength $PatH]
      for { set I 1 } { $I < $nE } { incr I } {
         set fN [file join $fN [lindex $PatH $I]]
      }
      set gmANS(HENAHOME) $fN
   } else { set gmANS(LoadH) 0 } 

   if { [string length $gmANS(EUVFILE)] == 0 }  { set gmANS(nEUV) 0 } 
   if { [string length $gmANS(MENAFILE)] == 0 } { set gmANS(nMENA) 0 } 
   if { [string length $gmANS(HENAFILE)] == 0 } { set gmANS(nHENA) 0 } 

   set gmANS(UpSp) 0
   set gmANS(sN)   0

   set gmANS(sPS)    ""
   for { set I 0 } { $I < $gmANS(sPCol) } { incr I } {
       lappend  gmANS(sPS) OPEN
   }
}
