package provide GMEPlot 1.0

# THIS gets and plots any SSIES data along the DMSP orbit track

proc SSIESMeasDef { iD mA mB MinV MaxV } {
   global gmANS env gLS 

   upvar $mA V
   upvar $mB Q

   switch -exact -- $iD {
      Ni {
         for { set J 0 } { $J < $nE } { incr J } {
             set V($J) [lindex $gmANS(aNi) $J]
             set Q($J) [lindex $gmANS(qNi) $J]
             if { $V($J) < $MinV } { set V($J) -1.0e10 }
             if { $V($J) > $MaxV } { set V($J) -1.0e10 }
         }
      }
      Te { 
         for { set J 0 } { $J < $nE } { incr J } {
             set V($J) [lindex $gmANS(aTe) $J]
             set Q($J) [lindex $gmANS(qTe) $J]
             if { $V($J) < $MinV } { set V($J) -1.0e10 }
             if { $V($J) > $MaxV } { set V($J) -1.0e10 }
         }
      }
      Ti { 
         for { set J 0 } { $J < $nE } { incr J } {
             set mD($J) [lindex $gmANS(aTi) $J]
             set Q($J) [lindex $gmANS(qTi) $J]
             if { $V($J) < $MinV } { set V($J) -1.0e10 }
             if { $V($J) > $MaxV } { set V($J) -1.0e10 }
         }
      }
      Vy { 
         for { set J 0 } { $J < $nE } { incr J } {
             set V($J) [lindex $gmANS(aVy) $J]
             set Q($J) [lindex $gmANS(qVy) $J]
             if { $V($J) < $MinV } { set V($J) -1.0e10 }
             if { $V($J) > $MaxV } { set V($J) -1.0e10 }
         }
      }
      Vx { 
         for { set J 0 } { $J < $nE } { incr J } {
             set V($J) [lindex $gmANS(aVx) $J]
             set Q($J) [lindex $gmANS(qVx) $J]
             if { $V($J) < $MinV } { set V($J) -1.0e10 }
             if { $V($J) > $MaxV } { set V($J) -1.0e10 }
         }
      }
      Vz { 
         for { set J 0 } { $J < $nE } { incr J } {
             set V($J) [lindex $gmANS(aVz) $J]
             set Q($J) [lindex $gmANS(qVz) $J]
             if { $V($J) < $MinV } { set V($J) -1.0e10 }
             if { $V($J) > $MaxV } { set V($J) -1.0e10 }
         }
      }
      TeCp { 
         for { set J 0 } { $J < $nE } { incr J } {
             set Ni [lindex $gmANS(aNi) $J]
             if { $Ni != 0.0 } {
                set V($J) [expr [lindex $gmANS(aTe) $J] * $Ni]
	     } else { $V($J) -1.0e-10 }
             set Ni [lindex $gmANS(qNi) $J]
             set Te [lindex $gmANS(qTe) $J]
             if { ($Ni < -1.0e-9) && ($Te < -1.0e-9) } {
                set $Q($J) -1.0e-10
             } else { set Q($J) [expr $Te * $Ni] }
		
             if { $V($J) < $MinV } { set V($J) -1.0e10 }
            if { $V($J) > $MaxV } { set V($J) -1.0e10 }
         }
      }
      TiCp { 
         for { set J 0 } { $J < $nE } { incr J } {
            set Ni [lindex $gmANS(aNi) $J]
            if { $Ni != 0.0 } {
                set V($J) [expr [lindex $gmANS(aTi) $J] * $Ni]
	    } else { $V($J) -1.0e-10 }
            set Ni [lindex $gmANS(qNi) $J]
            set Ti [lindex $gmANS(qTi) $J]
            if { ($Ni < -1.0e-9) && ($Ti < -1.0e-9) } {
              set $Q($J) -1.0e-10
            } else { set Q($J) [expr $Ti * $Ni] }
		
             if { $V($J) < $MinV } { set V($J) -1.0e10 }
             if { $V($J) > $MaxV } { set V($J) -1.0e10 }
         }
      }
      NH {
         for { set J 0 } { $J < $nE } { incr J } {
             set V($J) [lindex $gmANS(aH) $J]
             set Q($J) [lindex $gmANS(qH) $J]
             if { $V($J) < $MinV } { set V($J) -1.0e10 }
             if { $V($J) > $MaxV } { set V($J) -1.0e10 }
         }
      }
      NHe {
         for { set J 0 } { $J < $nE } { incr J } {
            set V($J) [lindex $gmANS(aHe) $J]
            set Q($J) [lindex $gmANS(qHe) $J]
            if { $V($J) < $MinV } { set V($J) -1.0e10 }
            if { $V($J) > $MaxV } { set V($J) -1.0e10 }
         }
      }
      NO {
         for { set J 0 } { $J < $nE } { incr J } {
            set V($J) [lindex $gmANS(aO) $J]
            set Q($J) [lindex $gmANS(qO) $J]
            if { $V($J) < $MinV } { set V($J) -1.0e10 }
            if { $V($J) > $MaxV } { set V($J) -1.0e10 }
         }
      }
   }
}
